breed [people person]

turtles-own[went-through]

patches-own [value door-value]

globals [
  people-evacuated
  people-inside
  time-passed
  time-limit
  plan-file
  plan-changed
  corners-top-left
  corners-top-right
  corners-bottom-left
  corners-bottom-right
  walls
  doors
  exits
]

to setup
  let plan-changed-tmp plan-changed
  let plan-file-tmp plan-file
  clear-globals
  clear-turtles
  reset-ticks
  clear-plot
  set plan-file plan-file-tmp
  set plan-changed plan-changed-tmp

  ifelse(not is-string? plan-file)[
    import-plan
  ][
    setup-variables
    setup-populate

    print plan-changed
    if(plan-changed = 1)[
      set plan-changed 0
      evaluate-way
    ]
  ]
end

to go
  switch-room
  move
  get-out

  tick
  update-time
  if(ticks >= time-limit or people-inside = 0)[ stop ]
end

;setup globals
to setup-variables
  ;default time limit 2 minutes
  if time-limit-minutes = 0 and time-limit-seconds = 0[
    set time-limit-minutes 2
    set time-limit-seconds 0
  ]

  ;set time limit for counting
  set time-limit (time-limit-minutes * 60 + time-limit-seconds)

  ;display values
  set time-passed "00:00"
  set people-inside people-in-the-building

  ;room corner arrays
  let corners-top-left-array []
  let corners-top-right-array []
  let corners-bottom-left-array []
  let corners-bottom-right-array []

  ;get corners in the plan
  ask patches with [pcolor = 0][
    let cur-x pxcor
    let cur-y pycor
    let neighborsCornerCnt count neighbors4 with [pcolor != 95 and pxcor = cur-x and pycor > cur-y] + count neighbors4 with [pcolor != 95 and pxcor > cur-x and pycor = cur-y ]
    if(neighborsCornerCnt = 2)[
      set corners-bottom-left-array lput self corners-bottom-left-array
    ]

    set neighborsCornerCnt count neighbors4 with [pcolor != 95 and pxcor = cur-x and pycor < cur-y] + count neighbors4 with [pcolor != 95 and pxcor > cur-x and pycor = cur-y ]
    if(neighborsCornerCnt = 2)[
      set corners-top-left-array lput self corners-top-left-array
    ]

    set neighborsCornerCnt count neighbors4 with [pcolor != 95 and pxcor = cur-x and pycor < cur-y] + count neighbors4 with [pcolor != 95 and pxcor < cur-x and pycor = cur-y ]
    if(neighborsCornerCnt = 2)[
      set corners-top-right-array lput self corners-top-right-array
    ]

    set neighborsCornerCnt count neighbors4 with [pcolor != 95 and pxcor = cur-x and pycor > cur-y] + count neighbors4 with [pcolor != 95 and pxcor < cur-x and pycor = cur-y ]
    if(neighborsCornerCnt = 2)[
      set corners-bottom-right-array lput self corners-bottom-right-array
    ]
  ]

  ;converting corner list into agentsets
  set corners-top-left patches with [member? self corners-top-left-array = true]
  set corners-top-right patches with [member? self corners-top-right-array = true]
  set corners-bottom-left patches with [member? self corners-bottom-left-array = true]
  set corners-bottom-right patches with [member? self corners-bottom-right-array = true]

  ;doors and exists
  set walls patches with [pcolor = 0]
  set doors patches with [pcolor = 5]
  set exits patches with [pcolor = 15]
end

;evaluate patches to guide agents out
to evaluate-way
  ask walls[set value 100000]
  ask exits[set value 0]

  ask doors[
    set door-value ( (distance (min-one-of exits[distance myself])) / 3 )
    set value 0
  ]

  ;detect rooms
  ask patches with [pcolor = 95 or pcolor = 5][
    let cur-x pxcor
    let cur-y pycor

    let top-wall-y -1
    let bottom-wall-y -1
    let left-wall-x -1
    let right-wall-x -1

    ;closest walls/doors/exits (room borders) cords
    ask min-one-of patches with [pcolor != 95 and pxcor = cur-x and pycor > cur-y][distance myself][ set top-wall-y pycor ]
    ask min-one-of patches with [pcolor != 95 and pxcor = cur-x and pycor < cur-y][distance myself][ set bottom-wall-y pycor ]
    ask min-one-of patches with [pcolor != 95 and pycor = cur-y and pxcor < cur-x][distance myself][ set left-wall-x pxcor ]
    ask min-one-of patches with [pcolor != 95 and pycor = cur-y and pxcor > cur-x][distance myself][ set right-wall-x pxcor ]

    ;room corners
    let corner-tl min-one-of corners-top-left with [pxcor < cur-x and pycor > cur-y and pxcor = left-wall-x and pycor = top-wall-y][distance myself]
    let corner-tr min-one-of corners-top-right with [pxcor > cur-x and pycor > cur-y and pxcor = right-wall-x and pycor = top-wall-y][distance myself]
    let corner-bl min-one-of corners-bottom-left with [pxcor < cur-x and pycor < cur-y and pxcor = left-wall-x and pycor = bottom-wall-y][distance myself]
    let corner-br min-one-of corners-bottom-right with [pxcor > cur-x and pycor < cur-y and pxcor = right-wall-x and pycor = bottom-wall-y][distance myself]

    ifelse(is-patch? corner-tl and is-patch? corner-tr and is-patch? corner-bl and is-patch? corner-br)[
      ;enclosed rooms
      let tl-x -1
      let tl-y -1
      ask corner-tl[
        set tl-x pxcor
        set tl-y pycor
      ]

      let tr-x -1
      let tr-y -1
      ask corner-tr[
        set tr-x pxcor
        set tr-y pycor
      ]

      let bl-x -1
      let bl-y -1
      ask corner-bl[
        set bl-x pxcor
        set bl-y pycor
      ]

      let br-x -1
      let br-y -1
      ask corner-br[
        set br-x pxcor
        set br-y pycor
      ]

      ;is exits
      let exitsCnt count exits with [pycor = tl-y and pxcor > tl-x and pxcor < tr-x] ;top wall
      set exitsCnt exitsCnt + count exits with [pycor = bl-y and pxcor > bl-x and pxcor < br-x] ;bottom wall
      set exitsCnt exitsCnt + count exits with [pxcor = tl-x and pycor > bl-y and pycor < tl-y] ;left wall
      set exitsCnt exitsCnt + count exits with [pxcor = tr-x and pycor > br-y and pycor < tr-y] ;right wall

      ;is doors
      let doorCnt count doors with [pycor = tl-y and pxcor > tl-x and pxcor < tr-x] ;top wall
      set doorCnt doorCnt + count doors with [pycor = bl-y and pxcor > bl-x and pxcor < br-x] ;bottom wall
      set doorCnt doorCnt + count doors with [pxcor = tl-x and pycor > bl-y and pycor < tl-y] ;left wall
      set doorCnt doorCnt + count doors with [pxcor = tr-x and pycor > br-y and pycor < tr-y] ;right wall

      ;guide to the nearest exit in the room or the nearest door inside the room
      ifelse(exitsCnt > 1)[
        set value ( (distance (min-one-of exits with[
         (pycor = tl-y and pxcor > tl-x and pxcor < tr-x) or ;top exit
         (pycor = bl-y and pxcor > bl-x and pxcor < br-x) or ;bottom exit
         (pxcor = tl-x and pycor > bl-y and pycor < tl-y) or ;left exit
         (pxcor = tr-x and pycor > br-y and pycor < tr-y) ;right exit
        ] [distance myself])) )
      ][
        ifelse(doorCnt > 1)[
          ;head to doors in room that are closest to nearest exit
          let closest-door-to-exit min-one-of doors with[
            (pycor = tl-y and pxcor > tl-x and pxcor < tr-x) or ;top door
            (pycor = bl-y and pxcor > bl-x and pxcor < br-x) or ;bottom door
            (pxcor = tl-x and pycor > bl-y and pycor < tl-y) or ;left door
            (pxcor = tr-x and pycor > br-y and pycor < tr-y) ;right door
          ][door-value]

          set cur-x 0
          set cur-y 0
          let closest-door-value 0
          ask closest-door-to-exit[
            set closest-door-value door-value
            set cur-x pxcor
            set cur-y pycor
          ]

          ;let closest-door scan-door cur-x cur-y
          ;let closest-door-patch min-one-of doors with[(member? self closest-door)] [distance self]

          set value ( (distance closest-door-to-exit) + closest-door-value * 5 )
        ][
          ;no doors
          set value ( (distance (min-one-of exits[distance myself])) )
        ]
      ]
    ][
      ;open space
      set value ( (distance (min-one-of exits [distance myself])) )
    ]
  ]
end

;ask uset to upload a file
to upload-building-plan
  set plan-file user-file
  if is-string? plan-file[
    import-plan
  ]
end

;import file
to import-plan
  ifelse is-string? plan-file [
    set plan-changed 1
    import-pcolors plan-file
  ][
    upload-building-plan
  ]
end

;populate walkable paths with people
to setup-populate
  ask n-of people-in-the-building patches with [pcolor = 95 and not any? other turtles-here][
    sprout-people 1[
      set size 2
      set color white
      set went-through []
    ]
  ]
end

;update time in UI
to update-time
  let minutes floor (ticks / 60)
  let seconds ticks mod 60

  if(minutes < 10)[set minutes (word "0" minutes)]
  if(seconds < 10)[set seconds (word "0" seconds)]

  set time-passed (word minutes ":" seconds)
end

;people getting out
to get-out
  set people-inside count people
  ask people [
    ask patch-here [
      if (pcolor = 15) [
        ask myself [
          set people-evacuated people-evacuated + 1
          die
        ]
      ]
    ]
  ]
end

;people moving
to move
  ask people[

    ;adjust speed if two many people here
    let speed 1
    if(count turtles in-radius 1 > 2)[set speed 0.7]
    if(count turtles in-radius 1 > 3)[set speed 0.5]
    if(count turtles in-radius 1 > 4)[set speed 0.3]

    let facing nobody
    let localvalue value
    let jump-dist 1
    let wt went-through
    let pcolor-here 0
    ask patch-here[
      set pcolor-here pcolor
    ]

    ifelse  speed < 1 [set jump-dist 1 ][set jump-dist speed]
    let candidates patches in-radius (jump-dist + 1) with[
      (
        (distance myself > 0) and (invision myself self) and (value <= localvalue or pcolor-here = 5) and
        (not member? self wt)
      )

    ]

    ifelse (any? candidates)[
      let minvalue [value] of min-one-of candidates [value]
      let winner one-of candidates with [value = minvalue]
      set facing winner
    ]
    []
    if facing != nobody [
      face facing
      jump speed
    ]
  ]

end

;if observer can see object = no walls between them, inspired by fire-code model (see info)
to-report invision [observer object]

  let reporter false

  ask observer [
    set reporter subtract-headings heading (towards object) <= 180 and subtract-headings heading (towards object) >= -180

    if reporter [
      let route 1
      let head towards object
      while [route < [distance object] of observer] [
        if ([pcolor] of patch-at-heading-and-distance head route) = black [
          set reporter false
        ]
        set route route + 1
      ]
    ]
  ]

  report reporter

end

;when people enter door they go through and dont return
to switch-room
  ask people[
    let cur-patch patch-here
    let cur-patch-color 0
    ask cur-patch[
      set cur-patch-color pcolor
    ]

    if(cur-patch-color = 5)[
      set went-through scan-door xcor ycor
    ]
  ]
end

;finds all door patches connected
to-report scan-door[cur-x cur-y]
  let door-patches []
  let cur-patch patch cur-x cur-y

  if(not member? cur-patch door-patches)[
    set door-patches lput cur-patch door-patches
  ]
  set door-patches sentence door-patches scan-door-cycle (cur-x + 1) cur-y 1 "x"
  set door-patches sentence door-patches scan-door-cycle (cur-x - 1) cur-y -1 "x"
  set door-patches sentence door-patches scan-door-cycle cur-x (cur-y + 1) 1 "y"
  set door-patches sentence door-patches scan-door-cycle cur-x (cur-y - 1) -1 "y"

  report door-patches
end

;suport function for scan-door
to-report scan-door-cycle[cur-x cur-y inc inccord]
  let door-patches []

  if(cur-x <= max-pxcor and cur-y <= max-pycor)[
    loop [
      let cur-patch patch cur-x cur-y
      let cur-patch-color 0
      ask cur-patch[
        set cur-patch-color pcolor
      ]

      ifelse(cur-patch-color != 5)[
        report door-patches
      ][
        if(not member? cur-patch door-patches)[
          set door-patches lput cur-patch door-patches
        ]
      ]

      ifelse(inccord = "x")[
        set cur-x cur-x + inc
      ][
        set cur-y cur-y + inc
      ]
    ]
  ]

  report door-patches
end
@#$#@#$#@
GRAPHICS-WINDOW
256
23
764
532
-1
-1
5.0
1
10
1
1
1
0
0
0
1
0
99
0
99
1
1
1
ticks
30.0

BUTTON
30
122
116
155
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
122
122
219
155
Evacuation (go)
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
30
164
219
197
people-in-the-building
people-in-the-building
50
500
500.0
50
1
NIL
HORIZONTAL

MONITOR
30
260
218
305
NIL
time-passed
17
1
11

MONITOR
30
311
219
356
# of people inside:
people-inside
17
1
11

MONITOR
30
363
219
408
# of people evacuated:
people-evacuated
17
1
11

CHOOSER
30
207
122
252
time-limit-minutes
time-limit-minutes
0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59
2

CHOOSER
125
207
217
252
time-limit-seconds
time-limit-seconds
0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59
20

MONITOR
28
24
217
69
Building plan filename
plan-file
17
1
11

BUTTON
29
73
218
106
Upload building plan
upload-building-plan
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
31
412
231
562
People evacuated from building
time
people-evacuated
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -2674135 true "" "plot people-evacuated"

@#$#@#$#@
## WHAT IS IT?

This model simulates evacuation proccess in a building specified by simplified blueprint plans. It allows user to visualize how evacuation is done in the building and lets him find out how many people can make it out in a certain time limit.

## HOW IT WORKS

When blueprint plan gets imported the program asigns a colors to patches and determines wheater it is a wall, door, exit or walkable path.

Because the blueprint can be different everytime the core of the problem was to detect rooms automaticly and simulate people acting inside of them. The walls and doors in a room are the only thing that people can actualy see, when they are inside of them. So people will escape through exits that are in the room, rather than go through one door eventhough there is a closer exit. Simply because they see the one in the room first. When people are stuck with clusters, the clusters move slowly, this means that more people causes the evacuation to slow down.

After setup button is pressed the program runs series of calculations to find the path out. It finds all corners in the plan and detect rooms. When rooms are detected the program finds all exits and doors in those rooms. It asigns values to all patches in the way based on distance to exits or doors in the room that are closest to a exit. Agents than follow the path. The simulation ends when time limit is reached or when all people got out of the building so you can see the exact number of evacuated people or the exact time of getting all of them out.

This allows the program to calculate the way only once when a plan gets imported. First setup will take a while because of calculations. Also when plan gets changed the program needs to recalculate of course.

## HOW TO USE IT

First the building blueprint needs to be imported. The application comes with three sample blueprints, it is possible to create one of your own (Guide at the end of the chapter). 

The UI consists of Three buttons one slider and two dropdowns to set timelimit.

### UPLOAD A BUILDING PLAN BUTTON

This button lets you choose a file to be imported as blueprint, it must be 100x100px.

### PEOPLE IN THE BUILDING SLIDER

Let's you set up how many people will be in the building before simulation starts.

### TIME LIMIT DROP DOWNS

Let's you set up time-limit. The simulation ends when time limit is reached so you can see how many people got out and how many people are still in the building.

### SETUP

When setup is pressed the program calculates a path if building plan was changed and populates the building with people.

### EVACUATION

This button runs a simulation.

### HOW TO CREATE A BULDING BLUEPRINT

Draw a schema of a building in size of 100x100px  
Each pixel represents a patch in netlogo.         
Colors to use are the following:

  * Black
    * HEX CODE: #000000
    * NETLOGO CODE: 0
    * REPRESENTS: Walls
  * Grey  
    * HEX CODE: #8d8d8d  
    * NETLOGO CODE: 5
    * REPRESENTS: Doors
  * Red   
    * HEX CODE: #d73229  
    * NETLOGO CODE: 15
    * REPRESENTS: Exits & windows
  * Blue  
    * HEX CODE: #2d8dbe  
    * NETLOGO CODE: 95
    * REPRESENTS: Walkable path

## THINGS TO TRY

Try changing building plans, number of people in the building and the time limit.

## RELATED MODELS

Model is inspired by fire escape example by Tomáš Šalamon. 

## CREDITS AND REFERENCES

Created by David Feldstein (feld00) as an assignment for course 4IT496,
University of Economics in Prague, 2018
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
