breed [fishes1 fish1]
breed [fishes2 fish2]
breed [fishes3 fish3]

breed [sharks shark]

breed [planktons plankton]

turtles-own [pace headx heady energy]

patches-own [ countdown1 countdown2 countdown3]

extensions [math]

globals [
  eaten-fishes1
  eaten-fishes2
  eaten-fishes3
  died-sharks
  ocean-color
  last-known-temperature ; aby tepolta ovlivnovala reprodukci jenom kdyz ji uzivatel zmeni
  last-known-pollution
  max-reproduce
]

to setup

  clear-all
  reset-ticks

  setup-ocean
  setup-fishes1
  setup-fishes2
  setup-fishes3
  setup-sharks
  setup-planktons
  set water-temperature 10
  set last-known-temperature 10
  set max-reproduce 20
  set pollution 0
  set last-known-pollution 0

end

to setup-ocean
  set ocean-color blue - 2
  set green-plant-regrowth-time 20
  set yellow-plant-regrowth-time 15
  set red-plant-regrowth-time 10

  ask patches [
    set pcolor one-of [ green yellow red]
      if pcolor = green
        [ set countdown1 green-plant-regrowth-time ]
    if pcolor = yellow
       [ set countdown2 yellow-plant-regrowth-time ]
     if pcolor = red
        [ set countdown3 red-plant-regrowth-time ]
  ]

  reset-ticks
end



to go
  water-temperature-function
  pollution-function
  if not any? turtles [ stop ]
  if not any? sharks [ user-message "The fishes have inherited the earth" stop ]

  ask fishes1 [
    move
    set energy energy - 1
    eat-plants fishes1 green
    eat-plants fishes1 yellow
    eat-plants fishes1 red
    death
    reproduce-fish1
  ]

  ask fishes2 [
    move
    set energy energy - 1
    eat-plants fishes2 yellow
    death
    reproduce-fish2
  ]

  ask fishes3 [
    move
    set energy energy - 1
    eat-plants fishes3 red
    eat-plankton
    death
    reproduce-fish3
  ]

  ask sharks [
    move
    set energy energy - 1
    eat-fishes
    death
    reproduce-sharks
  ]

   ask planktons [
    move
    reproduce-planktons
    death-plankton
  ]

  ask patches [ grow-red-grass ]
  ask patches [ grow-green-grass ]
  ask patches [ grow-yellow-grass ]

  tick

end

to water-temperature-function
  let a1 fish1-reproduce
  let a2 fish2-reproduce
  let a3 fish3-reproduce
  let b1 shark-reproduce

  if water-temperature > last-known-temperature [

    ask fishes1 [
      set fish1-reproduce (a1 + ((water-temperature - last-known-temperature) * 0.01 ))
      set fish1-reproduce ( round-function fish1-reproduce 2)
      if fish1-reproduce > max-reproduce [set fish1-reproduce max-reproduce]
    ]

    ask fishes2 [
      set fish2-reproduce (a2 + ((water-temperature - last-known-temperature) * 0.10 ))
      set fish2-reproduce ( round-function fish2-reproduce 2)
      if fish2-reproduce > max-reproduce [set fish2-reproduce max-reproduce]
    ]

    ask fishes3 [
      set fish3-reproduce (a3 + ((water-temperature - last-known-temperature) * 0.30 ))
      set fish3-reproduce ( round-function fish3-reproduce 2)
      if fish3-reproduce > max-reproduce [set fish3-reproduce max-reproduce]
    ]

      ask sharks [
        set shark-reproduce (b1 - ((water-temperature - last-known-temperature) * 0.08 ))
      set shark-reproduce ( round-function shark-reproduce 2)
        if shark-reproduce < 0 [set shark-reproduce 1]
      ] ]


    if water-temperature < last-known-temperature [

    ask fishes1 [
      set fish1-reproduce (a1 - ((last-known-temperature - water-temperature) * 0.01 ))
      set fish1-reproduce ( round-function fish1-reproduce 2)
      if fish1-reproduce < 0 [set fish1-reproduce 1]
    ]

    ask fishes2 [
      set fish2-reproduce (a2 - ((last-known-temperature - water-temperature) * 0.10 ))
      set fish2-reproduce ( round-function fish2-reproduce 2)
      if fish2-reproduce < 0 [set fish2-reproduce 1]
    ]

    ask fishes3 [
      set fish3-reproduce (a3 - ((last-known-temperature - water-temperature) * 0.3 ))
        set fish3-reproduce ( round-function fish3-reproduce 2)
      if fish3-reproduce < 0 [set fish3-reproduce 1]
    ]

      ask sharks [
        set shark-reproduce (b1 + ((last-known-temperature - water-temperature) / 2))
        set shark-reproduce ( round-function shark-reproduce 2)
        if shark-reproduce > max-reproduce [set shark-reproduce max-reproduce]
      ]]

      set last-known-temperature water-temperature
end

to pollution-function
  let a1 fish1-reproduce
  let a2 fish2-reproduce
  let a3 fish3-reproduce
  let b1 shark-reproduce
  let c1 green-plant-regrowth-time
  let c2 yellow-plant-regrowth-time
  let c3 red-plant-regrowth-time


  if pollution > last-known-pollution [
    let temp (1 - ((pollution - last-known-pollution) * 0.01))

  ask fishes1 [
      set fish1-reproduce (a1 * temp)
      set fish1-reproduce ( round-function fish1-reproduce 2)
      if fish1-reproduce < 1 [set fish1-reproduce 1]
    ]

  ask fishes2 [
      set fish2-reproduce (a2 * temp)
      set fish2-reproduce ( round-function fish2-reproduce 2)
      if fish2-reproduce < 1 [set fish2-reproduce 1]
    ]

  ask fishes3 [
      set fish3-reproduce (a3 * temp)
      set fish3-reproduce ( round-function fish3-reproduce 2)
      if fish3-reproduce < 1 [set fish3-reproduce 1]
    ]

   ask sharks [
        set shark-reproduce (b1 * temp)
      set shark-reproduce ( round-function shark-reproduce 2)
        if shark-reproduce < 1 [set shark-reproduce 1]
      ]

  set  green-plant-regrowth-time (c1 * (1 + ((pollution - last-known-pollution) * 0.01)))
    set green-plant-regrowth-time ( round-function green-plant-regrowth-time 2)
  if green-plant-regrowth-time > 30 [set green-plant-regrowth-time 30]

  set  yellow-plant-regrowth-time (c2 * (1 + ((pollution - last-known-pollution) * 0.10)))
    set yellow-plant-regrowth-time ( round-function yellow-plant-regrowth-time 2)
  if yellow-plant-regrowth-time > 30 [set yellow-plant-regrowth-time 30]

  set  red-plant-regrowth-time (c3 * (1 + ((pollution - last-known-pollution) * 0.25)))
    set red-plant-regrowth-time ( round-function red-plant-regrowth-time 2)
  if red-plant-regrowth-time > 30 [set red-plant-regrowth-time 30]

  ]

  if pollution < last-known-pollution [

  ask fishes1 [
      set fish1-reproduce (a1 * (1 + ((last-known-pollution - pollution) * 0.01)))
            set fish1-reproduce ( round-function fish1-reproduce 2)
      if fish1-reproduce > max-reproduce [set fish1-reproduce max-reproduce]
    ]

  ask fishes2 [
      set fish2-reproduce (a2 * (1 + ((last-known-pollution - pollution) * 0.10)))
            set fish2-reproduce ( round-function fish2-reproduce 2)
       if fish2-reproduce > max-reproduce [set fish2-reproduce max-reproduce]
    ]

  ask fishes3 [
      set fish3-reproduce (a3 * (1 + ((last-known-pollution - pollution) * 0.15)))
            set fish3-reproduce ( round-function fish3-reproduce 2)
       if fish3-reproduce > max-reproduce [set fish3-reproduce max-reproduce]
    ]

   ask sharks [
        set shark-reproduce (b1 * (1 + ((last-known-pollution - pollution) * 0.01)))
            set shark-reproduce ( round-function shark-reproduce 2)
        if shark-reproduce < 1 [set shark-reproduce 1]
      ]

  set  green-plant-regrowth-time (c1 * (1 - ((last-known-pollution - pollution) * 0.01)))
    set green-plant-regrowth-time ( round-function green-plant-regrowth-time 2)
  if green-plant-regrowth-time < 1 [set green-plant-regrowth-time 1]

  set  yellow-plant-regrowth-time (c2 * (1 - ((last-known-pollution - pollution) * 0.10)))
     set yellow-plant-regrowth-time ( round-function yellow-plant-regrowth-time 2)
  if yellow-plant-regrowth-time < 1 [set yellow-plant-regrowth-time 1]

  set  red-plant-regrowth-time (c3 *  (1 - ((last-known-pollution - pollution) * 0.25)))
     set red-plant-regrowth-time ( round-function red-plant-regrowth-time 2)
  if red-plant-regrowth-time < 1 [set red-plant-regrowth-time 1]

  ]

      set last-known-pollution pollution

end


to eat-plants [fishtype plant-color]
  if pcolor = plant-color [
    set pcolor ocean-color
    if fishtype = fishes1 [set energy energy + fish1-gain-from-food]
    if fishtype = fishes2 [set energy energy + fish2-gain-from-food]
    if fishtype = fishes3 [set energy energy + fish3-gain-from-food]
  ]
end


to grow-green-grass
  if pcolor = ocean-color [
    ifelse countdown1 <= 0
      [ set pcolor green
        set countdown1 green-plant-regrowth-time ]
      [ set countdown1 countdown1 - 1 ]
  ]
end

to grow-yellow-grass
  if pcolor = ocean-color [
    ifelse countdown2 <= 0
      [ set pcolor yellow
        set countdown2 yellow-plant-regrowth-time ]
      [ set countdown2 countdown2 - 1 ]
  ]
end

to grow-red-grass
  if pcolor = ocean-color [
    ifelse countdown3 <= 0
      [ set pcolor red
        set countdown3 red-plant-regrowth-time]
      [ set countdown3 countdown3 - 1 ]
  ]
end

to move
  rt random 50
  lt random 50
  fd pace
end


to death
  if energy < 0 [ die ]
end

to death-plankton
  if (random-float 100 * 2) < plankton-reproduce [  die ]
end

to eat-fishes
  let prey1 one-of fishes1-here
  if prey1 != nobody  [
    ask prey1 [ die ]
    set energy energy + shark-gain-from-food
  ]
    let prey2 one-of fishes2-here
  if prey2 != nobody  [
    ask prey2 [ die ]
    set energy energy + shark-gain-from-food
  ]
    let prey3 one-of fishes3-here
  if prey3 != nobody  [
    ask prey3 [ die ]
    set energy energy + shark-gain-from-food
  ]
end

to eat-plankton
  let prey1 one-of planktons-here
  if prey1 != nobody  [
    ask prey1 [ die ]
    set energy energy + fish3-gain-from-food
  ]
end

to create-random-patches [num-patches patch-color]
  repeat num-patches [
    let random-patch one-of patches
    ask random-patch [ set pcolor patch-color ]
  ]
end

to reproduce-fish1
  if (random-float 100 * 2) < fish1-reproduce [
    set energy (energy / 2)
    hatch 1 [ rt random-float 360 fd 1 ]
  ]
end

to reproduce-fish2
  if (random-float 100 * 2) < fish2-reproduce [
    set energy (energy / 2)
    hatch 1 [ rt random-float 360 fd 1 ]
  ]
end

to reproduce-fish3
  if (random-float 100 * 2) < fish3-reproduce [
    set energy (energy / 2)
    hatch 1 [ rt random-float 360 fd 1 ]
  ]
end

to reproduce-sharks
  if (random-float 100 * 1) < shark-reproduce  [
    set energy (energy / 2)
    hatch 1 [ rt random-float 360 fd 1 ]
  ]
end

to reproduce-planktons
  if (random-float 100 ) < plankton-reproduce  [
    set energy (energy / 2)
    hatch 1 [ rt random-float 360 fd 1 ]
  ]
end

to setup-fishes1
  create-fishes1 fishes1-number
  ask fishes1 [
    set shape  "fish1"
    set color blue + 3
    set energy random (2 * fish1-gain-from-food)
    setxy random-pxcor random-pycor
    set size 1.5
    set pace random-normal 1 0.5
  ]
end

to setup-fishes2

  create-fishes2 fishes2-number
  ask fishes2 [
    set shape  "fish 2"
    set color black
    set energy random (2 * fish2-gain-from-food)
    setxy random-pxcor random-pycor
    set size 1.5
    set pace random-normal 2 0.1
  ]
end

to setup-fishes3

  create-fishes3 fishes3-number
  ask fishes3 [
    set shape  "fish 3"
    set color red
    set energy random (2 * fish3-gain-from-food)
    setxy random-pxcor random-pycor
    set size 1.5
    set pace random-normal 1 0.1
  ]
end

to setup-sharks

  create-sharks sharks-number
  ask sharks [
    set shape  "shark"
    set color grey + 4
    setxy random-pxcor random-pycor
    set energy random (2 * shark-gain-from-food)
    set size 4
    set pace 0.1
  ]
end

to setup-planktons
  create-planktons planktons-number
  ask planktons [
    set shape  "circle"
    set color white
    set energy random-float 5
    setxy random-pxcor random-pycor
    set size 0.5
    set pace 5
  ]
end

to-report plant-red
    report patches with [pcolor = red]
end

to-report plant-yellow
    report patches with [pcolor = yellow]
end

to-report plant-green
    report patches with [pcolor = green]
end

to-report round-function [number precision1]
  report math:round (number * (10 ^ precision1)) / (10 ^ precision1)
end
@#$#@#$#@
GRAPHICS-WINDOW
997
14
1434
452
-1
-1
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
840
399
903
432
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
839
446
902
479
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
10
189
182
222
fishes1-number
fishes1-number
0
50
25.0
1
1
NIL
HORIZONTAL

SLIDER
10
231
182
264
fishes2-number
fishes2-number
0
50
25.0
1
1
NIL
HORIZONTAL

SLIDER
8
278
180
311
fishes3-number
fishes3-number
0
50
26.0
1
1
NIL
HORIZONTAL

SLIDER
6
353
178
386
sharks-number
sharks-number
0
30
12.0
1
1
NIL
HORIZONTAL

SLIDER
209
23
398
56
green-plant-regrowth-time
green-plant-regrowth-time
0
30
26.39
1
1
NIL
HORIZONTAL

SLIDER
208
65
401
98
yellow-plant-regrowth-time
yellow-plant-regrowth-time
0
30
30.0
1
1
NIL
HORIZONTAL

SLIDER
209
106
386
139
red-plant-regrowth-time
red-plant-regrowth-time
0
30
30.0
1
1
NIL
HORIZONTAL

SLIDER
206
185
378
218
fish1-gain-from-food
fish1-gain-from-food
0
50
16.0
1
1
NIL
HORIZONTAL

SLIDER
206
230
378
263
fish2-gain-from-food
fish2-gain-from-food
0
50
14.0
1
1
NIL
HORIZONTAL

SLIDER
206
271
378
304
fish3-gain-from-food
fish3-gain-from-food
0
50
13.0
1
1
NIL
HORIZONTAL

MONITOR
602
177
680
222
fishes1 blue
count fishes1
17
1
11

MONITOR
600
228
688
273
fishes2 black
count fishes2
17
1
11

MONITOR
600
284
673
329
fishes3 red
count fishes3
17
1
11

MONITOR
604
10
682
55
plant-green
count plant-green / 4
0
1
11

MONITOR
601
118
736
163
plant-yellow
count plant-yellow / 4
0
1
11

MONITOR
598
66
718
111
plant-red
count plant-red / 4
0
1
11

PLOT
758
26
958
176
plants
time
pop.
0.0
100.0
0.0
100.0
true
true
"" ""
PENS
"green" 1.0 0 -13840069 true "" "plot count plant-green / 4"
"yellow" 1.0 0 -1184463 true "" "plot count plant-yellow / 4"
"red" 1.0 0 -2674135 true "" "plot count plant-red / 4"

SLIDER
410
178
582
211
fish1-reproduce
fish1-reproduce
1.0
20.0
2.35
1.0
1
%
HORIZONTAL

SLIDER
405
233
577
266
fish2-reproduce
fish2-reproduce
1.0
20.0
2.82
1.0
1
%
HORIZONTAL

SLIDER
406
275
578
308
fish3-reproduce
fish3-reproduce
1.0
20.0
4.42
1.0
1
%
HORIZONTAL

SLIDER
400
353
572
386
shark-reproduce
shark-reproduce
1
20
1.55
1
1
%
HORIZONTAL

PLOT
757
202
957
352
fishes and sharks
time
pop.
0.0
100.0
0.0
100.0
true
true
"" ""
PENS
"sharks" 1.0 0 -4539718 true "" "plot count sharks"
"fishes-1 blue" 1.0 0 -13791810 true "" "plot count fishes1"
"fishes-2 black" 1.0 0 -16777216 true "" "plot count fishes2"
"fishes-3 red" 1.0 0 -2674135 true "" "plot count fishes3"
"planktons" 1.0 0 -2382653 true "" "plot count planktons"

SLIDER
206
351
378
384
shark-gain-from-food
shark-gain-from-food
0
50
15.0
1
1
NIL
HORIZONTAL

MONITOR
596
351
653
396
sharks
count sharks
17
1
11

SLIDER
1003
469
1191
502
water-temperature
water-temperature
0
20
16.0
1
1
degrees
HORIZONTAL

SLIDER
1209
470
1381
503
pollution
pollution
0
100
30.0
1
1
%
HORIZONTAL

SLIDER
6
402
178
435
planktons-number
planktons-number
0
30
14.0
1
1
NIL
HORIZONTAL

SLIDER
400
409
572
442
plankton-reproduce
plankton-reproduce
0
20
10.0
1
1
%
HORIZONTAL

MONITOR
597
411
701
456
planktons
count planktons
17
1
11

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

fish 2
false
0
Polygon -1 true false 56 133 34 127 12 105 21 126 23 146 16 163 10 194 32 177 55 173
Polygon -7500403 true true 156 229 118 242 67 248 37 248 51 222 49 168
Polygon -7500403 true true 30 60 45 75 60 105 50 136 150 53 89 56
Polygon -7500403 true true 50 132 146 52 241 72 268 119 291 147 271 156 291 164 264 208 211 239 148 231 48 177
Circle -1 true false 237 116 30
Circle -16777216 true false 241 127 12
Polygon -1 true false 159 228 160 294 182 281 206 236
Polygon -7500403 true true 102 189 109 203
Polygon -1 true false 215 182 181 192 171 177 169 164 152 142 154 123 170 119 223 163
Line -16777216 false 240 77 162 71
Line -16777216 false 164 71 98 78
Line -16777216 false 96 79 62 105
Line -16777216 false 50 179 88 217
Line -16777216 false 88 217 149 230

fish 3
false
0
Polygon -7500403 true true 137 105 124 83 103 76 77 75 53 104 47 136
Polygon -7500403 true true 226 194 223 229 207 243 178 237 169 203 167 175
Polygon -7500403 true true 137 195 124 217 103 224 77 225 53 196 47 164
Polygon -7500403 true true 40 123 32 109 16 108 0 130 0 151 7 182 23 190 40 179 47 145
Polygon -7500403 true true 45 120 90 105 195 90 275 120 294 152 285 165 293 171 270 195 210 210 150 210 45 180
Circle -1184463 true false 244 128 26
Circle -16777216 true false 248 135 14
Line -16777216 false 48 121 133 96
Line -16777216 false 48 179 133 204
Polygon -7500403 true true 241 106 241 77 217 71 190 75 167 99 182 125
Line -16777216 false 226 102 158 95
Line -16777216 false 171 208 225 205
Polygon -1 true false 252 111 232 103 213 132 210 165 223 193 229 204 247 201 237 170 236 137
Polygon -1 true false 135 98 140 137 135 204 154 210 167 209 170 176 160 156 163 126 171 117 156 96
Polygon -16777216 true false 192 117 171 118 162 126 158 148 160 165 168 175 188 183 211 186 217 185 206 181 172 171 164 156 166 133 174 121
Polygon -1 true false 40 121 46 147 42 163 37 179 56 178 65 159 67 128 59 116

fish1
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

flower budding
false
0
Polygon -7500403 true true 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Polygon -7500403 true true 189 233 219 188 249 173 279 188 234 218
Polygon -7500403 true true 180 255 150 210 105 210 75 240 135 240
Polygon -7500403 true true 180 150 180 120 165 97 135 84 128 121 147 148 165 165
Polygon -7500403 true true 170 155 131 163 175 167 196 136

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

leaf 2
false
0
Rectangle -7500403 true true 144 218 156 298
Polygon -7500403 true true 150 263 133 276 102 276 58 242 35 176 33 139 43 114 54 123 62 87 75 53 94 30 104 39 120 9 155 31 180 68 191 56 216 85 235 125 240 173 250 165 248 205 225 247 200 271 176 275

lily pad
false
0
Polygon -7500403 true true 148 151 137 37 119 25 111 36 78 54 40 99 30 137 32 175 56 223 87 251 137 275 157 275 213 250 239 221 257 178 262 137 244 91 210 53 172 37 160 22 154 36
Line -13840069 false 154 151 207 97
Circle -13840069 false false 133 148 26
Line -13840069 false 52 122 134 157
Line -13840069 false 133 171 89 196
Line -13840069 false 147 193 147 254
Line -13840069 false 157 171 205 233
Line -13840069 false 161 161 204 163
Line -13840069 false 141 149 111 72

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

monster
false
0
Polygon -7500403 true true 75 150 90 195 210 195 225 150 255 120 255 45 180 0 120 0 45 45 45 120
Circle -16777216 true false 165 60 60
Circle -16777216 true false 75 60 60
Polygon -7500403 true true 225 150 285 195 285 285 255 300 255 210 180 165
Polygon -7500403 true true 75 150 15 195 15 285 45 300 45 210 120 165
Polygon -7500403 true true 210 210 225 285 195 285 165 165
Polygon -7500403 true true 90 210 75 285 105 285 135 165
Rectangle -7500403 true true 135 165 165 270

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

shark
false
0
Polygon -7500403 true true 283 153 288 149 271 146 301 145 300 138 247 119 190 107 104 117 54 133 39 134 10 99 9 112 19 142 9 175 10 185 40 158 69 154 64 164 80 161 86 156 132 160 209 164
Polygon -7500403 true true 199 161 152 166 137 164 169 154
Polygon -7500403 true true 188 108 172 83 160 74 156 76 159 97 153 112
Circle -16777216 true false 256 129 12
Line -16777216 false 222 134 222 150
Line -16777216 false 217 134 217 150
Line -16777216 false 212 134 212 150
Polygon -7500403 true true 78 125 62 118 63 130
Polygon -7500403 true true 121 157 105 161 101 156 106 152

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.4.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
