globals [male-customers female-customers]

breed [male_customers male_customer ]
breed [female_customers female_customer ]
breed [drinks drink]

male_customers-own [pace count_of_drinks time_in_stage_area ticks-since-here count-down_drink current-target-patch my_drink my-drink waiting_time unhappy_index unhappy_male_customer my-exit my_exit my-TOI my_TOI count-down_TOI total_drinks]
female_customers-own [pace count_of_drinks time_in_stage_area ticks-since-here count-down_drink current-target-patch my_drink my-drink waiting_time unhappy_index unhappy_female_customer my-exit my_exit my-TOI my_TOI count-down_TOI total_drinks]
drinks-own [drinkx drinky]
patches-own [pocet_navstevniku_na_poli pocet_nespokojenych_zakazniku]

to setup
  clear-all
  reset-ticks

  setup-patches
  setup-stage
  setup-stage_area
  setup-stage
  setup-toi
  setup-drinks
  setup-male_customers 0.5 * Pocet_navstevniku
  setup-female_customers 0.5 * Pocet_navstevniku
  waiting_area
  setup-drinks
  setup-exits
  setup-toi
  setup-free_pee_area

  reset-ticks
end

to start
 setup-end_of_festival
 customers_move

 thirsty_customer
 thirsty_customer_move
 thirsty_waiting_customer

 needtopee_customer
 needtopee_customer_move
 needtopee_waiting_customer
 free_pee_customers

 waiting_customer
 set-unhappy_customers

 tick

end

to setup-male_customers [number]
  create-male_customers number
  ask male_customers [

    setxy -50 34
    set shape "person"
    set size 1.25
    set color 105
    set pace 2
    set count_of_drinks 0
    set ticks-since-here 0
    set count-down_drink (3)
    set my-drink 0
    set male-customers male-customers + 1
    set waiting_time -15
    set unhappy_index 0
    set unhappy_male_customer "NO"
    set my-exit 0
    set my-TOI 0
    set count-down_TOI 2
    set total_drinks 0
  ]
end

to setup-female_customers [number]
  create-female_customers number
  ask female_customers [
    setxy -50 34
    set shape "person"
    set size 1.25
    set color 135
    set pace 2
    set count_of_drinks 0
    set ticks-since-here 0
    set count-down_drink (3)
    set my-drink 0
    set female-customers female-customers + 1
    set waiting_time -15
    set unhappy_index 0
    set unhappy_female_customer "NO"
    set my-exit 0
    set my-TOI 0
    set count-down_TOI 5
    set total_drinks 0
   ]
end

to setup-patches
  ask patches [ set pcolor 54 ]
end

to setup-stage
ask patches at-points [
[-40 50]	[-39 50]	[-38 50]	[-37 50]	[-36 50]	[-35 50]	[-34 50]	[-33 50]	[-32 50]	[-31 50]	[-30 50]	[-29 50]	[-28 50]	[-27 50]	[-26 50]	[-25 50]	[-24 50]	[-23 50]	[-22 50]	[-21 50]	[-20 50]	[-19 50]	[-18 50]	[-17 50]	[-16 50]	[-15 50]	[-14 50]	[-13 50]	[-12 50]	[-11 50]	[-10 50]	[-9 50]	[-8 50]	[-7 50]	[-6 50]	[-5 50]	[-4 50]	[-3 50]	[-2 50]	[-1 50]	[0 50 ]	[1 50 ]	[2 50 ]	[3 50 ]	[4 50 ]	[5 50 ]	[6 50 ]	[7 50 ]	[8 50 ]	[9 50 ]	[10 50]	[11 50]	[12 50]	[13 50]	[14 50]	[15 50]	[16 50]	[17 50]	[18 50]	[19 50]	[20 50]	[21 50]	[22 50]	[23 50]	[24 50]	[25 50]	[26 50]	[27 50]	[28 50]	[29 50]	[30 50]	[31 50]	[32 50]	[33 50]	[34 50]	[35 50]	[36 50]	[37 50]	[38 50]	[39 50]	[40 50]
[-40 49]	[-39 49]	[-38 49]	[-37 49]	[-36 49]	[-35 49]	[-34 49]	[-33 49]	[-32 49]	[-31 49]	[-30 49]	[-29 49]	[-28 49]	[-27 49]	[-26 49]	[-25 49]	[-24 49]	[-23 49]	[-22 49]	[-21 49]	[-20 49]	[-19 49]	[-18 49]	[-17 49]	[-16 49]	[-15 49]	[-14 49]	[-13 49]	[-12 49]	[-11 49]	[-10 49]	[-9 49]	[-8 49]	[-7 49]	[-6 49]	[-5 49]	[-4 49]	[-3 49]	[-2 49]	[-1 49]	[0 49 ]	[1 49 ]	[2 49 ]	[3 49 ]	[4 49 ]	[5 49 ]	[6 49 ]	[7 49 ]	[8 49 ]	[9 49 ]	[10 49]	[11 49]	[12 49]	[13 49]	[14 49]	[15 49]	[16 49]	[17 49]	[18 49]	[19 49]	[20 49]	[21 49]	[22 49]	[23 49]	[24 49]	[25 49]	[26 49]	[27 49]	[28 49]	[29 49]	[30 49]	[31 49]	[32 49]	[33 49]	[34 49]	[35 49]	[36 49]	[37 49]	[38 49]	[39 49]	[40 49]
[-40 48]	[-39 48]	[-38 48]	[-37 48]	[-36 48]	[-35 48]	[-34 48]	[-33 48]	[-32 48]	[-31 48]	[-30 48]	[-29 48]	[-28 48]	[-27 48]	[-26 48]	[-25 48]	[-24 48]	[-23 48]	[-22 48]	[-21 48]	[-20 48]	[-19 48]	[-18 48]	[-17 48]	[-16 48]	[-15 48]	[-14 48]	[-13 48]	[-12 48]	[-11 48]	[-10 48]	[-9 48]	[-8 48]	[-7 48]	[-6 48]	[-5 48]	[-4 48]	[-3 48]	[-2 48]	[-1 48]	[0 48 ]	[1 48 ]	[2 48 ]	[3 48 ]	[4 48 ]	[5 48 ]	[6 48 ]	[7 48 ]	[8 48 ]	[9 48 ]	[10 48]	[11 48]	[12 48]	[13 48]	[14 48]	[15 48]	[16 48]	[17 48]	[18 48]	[19 48]	[20 48]	[21 48]	[22 48]	[23 48]	[24 48]	[25 48]	[26 48]	[27 48]	[28 48]	[29 48]	[30 48]	[31 48]	[32 48]	[33 48]	[34 48]	[35 48]	[36 48]	[37 48]	[38 48]	[39 48]	[40 48]	
[-40 47]	[-39 47]	[-38 47]	[-37 47]	[-36 47]	[-35 47]	[-34 47]	[-33 47]	[-32 47]	[-31 47]	[-30 47]	[-29 47]	[-28 47]	[-27 47]	[-26 47]	[-25 47]	[-24 47]	[-23 47]	[-22 47]	[-21 47]	[-20 47]	[-19 47]	[-18 47]	[-17 47]	[-16 47]	[-15 47]	[-14 47]	[-13 47]	[-12 47]	[-11 47]	[-10 47]	[-9 47]	[-8 47]	[-7 47]	[-6 47]	[-5 47]	[-4 47]	[-3 47]	[-2 47]	[-1 47]	[0 47 ]	[1 47 ]	[2 47 ]	[3 47 ]	[4 47 ]	[5 47 ]	[6 47 ]	[7 47 ]	[8 47 ]	[9 47 ]	[10 47]	[11 47]	[12 47]	[13 47]	[14 47]	[15 47]	[16 47]	[17 47]	[18 47]	[19 47]	[20 47]	[21 47]	[22 47]	[23 47]	[24 47]	[25 47]	[26 47]	[27 47]	[28 47]	[29 47]	[30 47]	[31 47]	[32 47]	[33 47]	[34 47]	[35 47]	[36 47]	[37 47]	[38 47]	[39 47]	[40 47]
[-40 46]	[-39 46]	[-38 46]	[-37 46]	[-36 46]	[-35 46]	[-34 46]	[-33 46]	[-32 46]	[-31 46]	[-30 46]	[-29 46]	[-28 46]	[-27 46]	[-26 46]	[-25 46]	[-24 46]	[-23 46]	[-22 46]	[-21 46]	[-20 46]	[-19 46]	[-18 46]	[-17 46]	[-16 46]	[-15 46]	[-14 46]	[-13 46]	[-12 46]	[-11 46]	[-10 46]	[-9 46]	[-8 46]	[-7 46]	[-6 46]	[-5 46]	[-4 46]	[-3 46]	[-2 46]	[-1 46]	[0 46 ]	[1 46 ]	[2 46 ]	[3 46 ]	[4 46 ]	[5 46 ]	[6 46 ]	[7 46 ]	[8 46 ]	[9 46 ]	[10 46]	[11 46]	[12 46]	[13 46]	[14 46]	[15 46]	[16 46]	[17 46]	[18 46]	[19 46]	[20 46]	[21 46]	[22 46]	[23 46]	[24 46]	[25 46]	[26 46]	[27 46]	[28 46]	[29 46]	[30 46]	[31 46]	[32 46]	[33 46]	[34 46]	[35 46]	[36 46]	[37 46]	[38 46]	[39 46]	[40 46]	
[-40 45]	[-39 45]	[-38 45]	[-37 45]	[-36 45]	[-35 45]	[-34 45]	[-33 45]	[-32 45]	[-31 45]	[-30 45]	[-29 45]	[-28 45]	[-27 45]	[-26 45]	[-25 45]	[-24 45]	[-23 45]	[-22 45]	[-21 45]	[-20 45]	[-19 45]	[-18 45]	[-17 45]	[-16 45]	[-15 45]	[-14 45]	[-13 45]	[-12 45]	[-11 45]	[-10 45]	[-9 45]	[-8 45]	[-7 45]	[-6 45]	[-5 45]	[-4 45]	[-3 45]	[-2 45]	[-1 45]	[0 45 ]	[1 45 ]	[2 45 ]	[3 45 ]	[4 45 ]	[5 45 ]	[6 45 ]	[7 45 ]	[8 45 ]	[9 45 ]	[10 45]	[11 45]	[12 45]	[13 45]	[14 45]	[15 45]	[16 45]	[17 45]	[18 45]	[19 45]	[20 45]	[21 45]	[22 45]	[23 45]	[24 45]	[25 45]	[26 45]	[27 45]	[28 45]	[29 45]	[30 45]	[31 45]	[32 45]	[33 45]	[34 45]	[35 45]	[36 45]	[37 45]	[38 45]	[39 45]	[40 45]
[-40 44]	[-39 44]	[-38 44]	[-37 44]	[-36 44]	[-35 44]	[-34 44]	[-33 44]	[-32 44]	[-31 44]	[-30 44]	[-29 44]	[-28 44]	[-27 44]	[-26 44]	[-25 44]	[-24 44]	[-23 44]	[-22 44]	[-21 44]	[-20 44]	[-19 44]	[-18 44]	[-17 44]	[-16 44]	[-15 44]	[-14 44]	[-13 44]	[-12 44]	[-11 44]	[-10 44]	[-9 44]	[-8 44]	[-7 44]	[-6 44]	[-5 44]	[-4 44]	[-3 44]	[-2 44]	[-1 44]	[0 45 ]	[1 45 ]	[2 45 ]	[3 45 ]	[4 45 ]	[5 45 ]	[6 45 ]	[7 45 ]	[8 45 ]	[9 45 ]	[10 44]	[11 44]	[12 44]	[13 44]	[14 44]	[15 44]	[16 44]	[17 44]	[18 44]	[19 44]	[20 44]	[21 44]	[22 44]	[23 44]	[24 44]	[25 44]	[26 44]	[27 44]	[28 44]	[29 44]	[30 44]	[31 44]	[32 44]	[33 44]	[34 44]	[35 44]	[36 44]	[37 44]	[38 44]	[39 44]	[40 44][-4 44]	[-3 44]	[-2 44]	[-1 44]	[0 44 ]	[1 44 ]	[2 44 ]	[3 44 ]	[4 44 ]	[5 44 ] [6 44] [7 44 ] [8 44 ] [9 44 ]
[-40 43]	[-39 43]	[-38 43]	[-37 43]	[-36 43]	[-35 43]	[-34 43]	[-33 43]	[-32 43]	[-31 43]	[-30 43]	[-29 43]	[-28 43]	[-27 43]	[-26 43]	[-25 43]	[-24 43]	[-23 43]	[-22 43]	[-21 43]	[-20 43]	[-19 43]	[-18 43]	[-17 43]	[-16 43]	[-15 43]	[-14 43]	[-13 43]	[-12 43]	[-11 43]	[-10 43]	[-9 43]	[-8 43]	[-7 43]	[-6 43]	[-5 43]	[-4 43]	[-3 43]	[-2 43]	[-1 43]	[0 45 ]	[1 45 ]	[2 45 ]	[3 45 ]	[4 45 ]	[5 45 ]	[6 45 ]	[7 45 ]	[8 45 ]	[9 45 ]	[10 43]	[11 43]	[12 43]	[13 43]	[14 43]	[15 43]	[16 43]	[17 43]	[18 43]	[19 43]	[20 43]	[21 43]	[22 43]	[23 43]	[24 43]	[25 43]	[26 43]	[27 43]	[28 43]	[29 43]	[30 43]	[31 43]	[32 43]	[33 43]	[34 43]	[35 43]	[36 43]	[37 43]	[38 43]	[39 43]	[40 43][-5 43]	[-4 43]	[-3 43]	[-2 43]	[-1 43]	[0 43 ]	[1 43 ]	[2 43 ]	[3 43 ]	[4 43 ]	[5 43]	[6 43] [7 43] [8 43] [9 43]
[-40 42]	[-39 42]	[-38 42]	[-37 42]	[-36 42]	[-35 42]	[-34 42]	[-33 42]	[-32 42]	[-31 42]	[-30 42]	[-29 42]	[-28 42]	[-27 42]	[-26 42]	[-25 42]	[-24 42]	[-23 42]	[-22 42]	[-21 42]	[-20 42]	[-19 42]	[-18 42]	[-17 42]	[-16 42]	[-15 42]	[-14 42]	[-13 42]	[-12 42]	[-11 42]	[-10 42]	[-9 42]	[-8 42]	[-7 42]	[-6 42]	[-5 42]	[-4 42]	[-3 42]	[-2 42]	[-1 42]	[0 45 ]	[1 45 ]	[2 45 ]	[3 45 ]	[4 45 ]	[5 45 ]	[6 45 ]	[7 45 ]	[8 45 ]	[9 45 ]	[10 42]	[11 42]	[12 42]	[13 42]	[14 42]	[15 42]	[16 42]	[17 42]	[18 42]	[19 42]	[20 42]	[21 42]	[22 42]	[23 42]	[24 42]	[25 42]	[26 42]	[27 42]	[28 42]	[29 42]	[30 42]	[31 42]	[32 42]	[33 42]	[34 42]	[35 42]	[36 42]	[37 42]	[38 42]	[39 42]	[40 42][-5 42]	[-4 42]	[-3 42]	[-2 42]	[-1 42]	[0 42 ]	[1 42 ]	[2 42 ]	[3 42 ]	[4 42 ]	[5 42 ] [6 42] [7 42] [8 42] [9 42]
[-40 41]	[-39 41]	[-38 41]	[-37 41]	[-36 41]	[-35 41]	[-34 41]	[-33 41]	[-32 41]	[-31 41]	[-30 41]	[-29 41]	[-28 41]	[-27 41]	[-26 41]	[-25 41]	[-24 41]	[-23 41]	[-22 41]	[-21 41]	[-20 41]	[-19 41]	[-18 41]	[-17 41]	[-16 41]	[-15 41]	[-14 41]	[-13 41]	[-12 41]	[-11 41]	[-10 41]	[-9 41]	[-8 41]	[-7 41]	[-6 41]	[-5 41]	[-4 41]	[-3 41]	[-2 41]	[-1 41]	[0 45 ]	[1 45 ]	[2 45 ]	[3 45 ]	[4 45 ]	[5 45 ]	[6 45 ]	[7 45 ]	[8 45 ]	[9 45 ]	[10 41]	[11 41]	[12 41]	[13 41]	[14 41]	[15 41]	[16 41]	[17 41]	[18 41]	[19 41]	[20 41]	[21 41]	[22 41]	[23 41]	[24 41]	[25 41]	[26 41]	[27 41]	[28 41]	[29 41]	[30 41]	[31 41]	[32 41]	[33 41]	[34 41]	[35 41]	[36 41]	[37 41]	[38 41]	[39 41]	[40 41][-5 41]	[-4 41]	[-3 41]	[-2 41]	[-1 41]	[0 41 ]	[1 41 ]	[2 41 ]	[3 41 ]	[4 41 ]	[5 41 ]	[6 41] [7 41] [8 41] [9 41]
[-40 40]	[-39 40]	[-38 40]	[-37 40]	[-36 40]	[-35 40]	[-34 40]	[-33 40]	[-32 40]	[-31 40]	[-30 40]	[-29 40]	[-28 40]	[-27 40]	[-26 40]	[-25 40]	[-24 40]	[-23 40]	[-22 40]	[-21 40]	[-20 40]	[-19 40]	[-18 40]	[-17 40]	[-16 40]	[-15 40]	[-14 40]	[-13 40]	[-12 40]	[-11 40]	[-10 40]	[-9 40]	[-8 40]	[-7 40]	[-6 40]	[-5 40]	[-4 40]	[-3 40]	[-2 40]	[-1 40]	[0 45 ]	[1 45 ]	[2 45 ]	[3 45 ]	[4 45 ]	[5 45 ]	[6 45 ]	[7 45 ]	[8 45 ]	[9 45 ]	[10 40]	[11 40]	[12 40]	[13 40]	[14 40]	[15 40]	[16 40]	[17 40]	[18 40]	[19 40]	[20 40]	[21 40]	[22 40]	[23 40]	[24 40]	[25 40]	[26 40]	[27 40]	[28 40]	[29 40]	[30 40]	[31 40]	[32 40]	[33 40]	[34 40]	[35 40]	[36 40]	[37 40]	[38 40]	[39 40]	[40 40][-5 40]	[-4 40]	[-3 40]	[-2 40]	[-1 40]	[0 40 ]	[1 40 ]	[2 40 ]	[3 40 ]	[4 40 ]	[5 40 ] [6 40] [7 40] [8 40] [9 40]
  ][ set pcolor 1 ]
end

to setup-stage_area
 ask patches with [pcolor = 1][
    ask patches in-radius 40 [
      set pcolor 54.01
    ]
  ]
end

to setup-free_pee_area
  ask patches at-points [[-50 -36] [-50 -35] [-50 -34][-50 -33] [-50 -32] [-50 -31][50 -36] [50 -35] [50 -34][50 -33] [50 -32] [50 -31][-49 -36] [-49 -35] [-49 -34][-49 -33] [-49 -32] [-49 -31][49 -36] [49 -35] [49 -34][49 -33] [49 -32] [49 -31]][set pcolor 54.08 ]
end


to setup-exits
  ; exit 1
  ask patches at-points [[-50 35] [-50 34] [-50 36][-49 35] [-49 34] [-49 36]] [set pcolor 54.04 ]
  ask patches at-points [[-50 33] [-50 37]] [set pcolor 1.1 ]

  ; exit 2
  ask patches at-points [[50 35] [50 34] [50 36][49 35] [49 34] [49 36]] [set pcolor 54.04 ]
  ask patches at-points [[50 33] [50 37]] [set pcolor 1.1 ]

end

to setup-drinks
  create-drinks 1
  ask drink 0 [
    set drinkx  50
    set drinky -5]
  if pocet_napojovych_stanku = 1 [ask patches at-points [[50 3] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 2 [ask patches at-points [[50 3][50 2] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 3 [ask patches at-points [[50 3][50 2][50 1] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 4 [ask patches at-points [[50 3][50 2][50 1][50 0] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 5 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 6 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 7 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 8 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 9 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 10 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 11 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 12 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 13 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 14 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 15 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 16 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 17 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 18 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 19 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 20 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 21 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 22 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 23 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 24 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 25 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 26 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 27 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 28 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 29 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 30 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 31 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 32 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 33 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 34 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 35 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 36 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 37 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 38 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 39 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 40 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 41 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 42 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 43 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 44 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 45 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 46 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 47 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 48 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 49 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 50 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 51 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 52 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 53 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 54 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 55 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 56 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 57 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 58 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 59 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 60 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 61 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 62 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 63 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 64 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 65 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 66 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 67 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 68 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 69 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 70 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 71 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 72 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 73 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 74 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 75 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 76 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 77 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 78 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 79 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 80 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 81 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 82 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 83 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 84 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 85 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 86 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19][-50 19] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 87 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19][-50 19][50 20] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 88 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19][-50 19][50 20][-50 20] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 89 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19][-50 19][50 20][-50 20][50 21] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 90 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19][-50 19][50 20][-50 20][50 21][-50 21] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 91 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19][-50 19][50 20][-50 20][50 21][-50 21][50 22] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 92 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19][-50 19][50 20][-50 20][50 21][-50 21][50 22][-50 22] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 93 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19][-50 19][50 20][-50 20][50 21][-50 21][50 22][-50 22][50 23] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 94 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19][-50 19][50 20][-50 20][50 21][-50 21][50 22][-50 22][50 23][-50 23] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 95 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19][-50 19][50 20][-50 20][50 21][-50 21][50 22][-50 22][50 23][-50 23][50 24] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 96 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19][-50 19][50 20][-50 20][50 21][-50 21][50 22][-50 22][50 23][-50 23][50 24][-50 24] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 97 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19][-50 19][50 20][-50 20][50 21][-50 21][50 22][-50 22][50 23][-50 23][50 24][-50 24][50 25] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 98 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19][-50 19][50 20][-50 20][50 21][-50 21][50 22][-50 22][50 23][-50 23][50 24][-50 24][50 25][-50 25] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 99 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19][-50 19][50 20][-50 20][50 21][-50 21][50 22][-50 22][50 23][-50 23][50 24][-50 24][50 25][-50 25][50 26] ] [ set pcolor 45 ]]
 if pocet_napojovych_stanku = 100 [ask patches at-points [[50 3][50 2][50 1][50 0][50 -1][-50 3][-50 2][-50 1][-50 0][-50 -1][50 -2][-50 -2][50 -3][-50 -3][50 -4][-50 -4][50 -5][-50 -5][50 -6][-50 -6][50 -7][-50 -7][50 -8][-50 -8][50 -9][-50 -9][50 -10][-50 -10][50 -11][-50 -11][50 -12][-50 -12][50 -13][-50 -13][50 -14][-50 -14][50 -15][-50 -15][50 -16][-50 -16][50 -17][-50 -17][50 -18][-50 -18][50 -19][-50 -19][50 -20][-50 -20][50 -21][-50 -21][50 -22][-50 -22][50 -23][-50 -23][50 4][-50 4][50 5][-50 5][50 6][-50 6][50 7][-50 7][50 8][-50 8][50 9][-50 9][50 10][-50 10][50 11][-50 11][50 12][-50 12][50 13][-50 13][50 14][-50 14][50 15][-50 15][50 16][-50 16][50 17][-50 17][50 18][-50 18][50 19][-50 19][50 20][-50 20][50 21][-50 21][50 22][-50 22][50 23][-50 23][50 24][-50 24][50 25][-50 25][50 26][-50 26] ] [ set pcolor 45 ]]

  ask drinks[
    hide-turtle]
end



to setup-toi
 if pocet_TOITOI = 1 [ask patches at-points [[0 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 2 [ask patches at-points [[0 -50][1 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 3 [ask patches at-points [[0 -50][1 -50][-1 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 4 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 5 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 6 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 7 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 8 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 9 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 10 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 11 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 12 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 13 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 14 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 15 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 16 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 17 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 18 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 19 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 20 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 21 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 22 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 23 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 24 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 25 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 26 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 27 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 28 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 29 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 30 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 31 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 32 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 33 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 34 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 35 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 36 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 37 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 38 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 39 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 40 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 41 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 42 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 43 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 44 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 45 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 46 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 47 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 48 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 49 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 50 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 51 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 52 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 53 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 54 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 55 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 56 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 57 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 58 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 59 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 60 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 61 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 62 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 63 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 64 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 65 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 66 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 67 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 68 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 69 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 70 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 71 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 72 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 73 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 74 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 75 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 76 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 77 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 78 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 79 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 80 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 81 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 82 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 83 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 84 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 85 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 86 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50][43 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 87 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50][43 -50][-43 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 88 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50][43 -50][-43 -50][44 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 89 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50][43 -50][-43 -50][44 -50][-44 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 90 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50][43 -50][-43 -50][44 -50][-44 -50][45 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 91 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50][43 -50][-43 -50][44 -50][-44 -50][45 -50][-45 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 92 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50][43 -50][-43 -50][44 -50][-44 -50][45 -50][-45 -50][46 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 93 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50][43 -50][-43 -50][44 -50][-44 -50][45 -50][-45 -50][46 -50][-46 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 94 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50][43 -50][-43 -50][44 -50][-44 -50][45 -50][-45 -50][46 -50][-46 -50][47 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 95 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50][43 -50][-43 -50][44 -50][-44 -50][45 -50][-45 -50][46 -50][-46 -50][47 -50][-47 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 96 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50][43 -50][-43 -50][44 -50][-44 -50][45 -50][-45 -50][46 -50][-46 -50][47 -50][-47 -50][48 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 97 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50][43 -50][-43 -50][44 -50][-44 -50][45 -50][-45 -50][46 -50][-46 -50][47 -50][-47 -50][48 -50][-48 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 98 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50][43 -50][-43 -50][44 -50][-44 -50][45 -50][-45 -50][46 -50][-46 -50][47 -50][-47 -50][48 -50][-48 -50][49 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 99 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50][43 -50][-43 -50][44 -50][-44 -50][45 -50][-45 -50][46 -50][-46 -50][47 -50][-47 -50][48 -50][-48 -50][49 -50][-49 -50]] [ set pcolor 102 ]]
if pocet_TOITOI = 100 [ask patches at-points [[0 -50][1 -50][-1 -50][2 -50][-2 -50][3 -50][-3 -50][4 -50][-4 -50][5 -50][-5 -50][6 -50][-6 -50][7 -50][-7 -50][8 -50][-8 -50][9 -50][-9 -50][10 -50][-10 -50][11 -50][-11 -50][12 -50][-12 -50][13 -50][-13 -50][14 -50][-14 -50][15 -50][-15 -50][16 -50][-16 -50][17 -50][-17 -50][18 -50][-18 -50][19 -50][-19 -50][20 -50][-20 -50][21 -50][-21 -50][22 -50][-22 -50][23 -50][-23 -50][24 -50][-24 -50][25 -50][-25 -50][26 -50][-26 -50][27 -50][-27 -50][28 -50][-28 -50][29 -50][-29 -50][30 -50][-30 -50][31 -50][-31 -50][32 -50][-32 -50][33 -50][-33 -50][34 -50][-34 -50][35 -50][-35 -50][36 -50][-36 -50][37 -50][-37 -50][38 -50][-38 -50][39 -50][-39 -50][40 -50][-40 -50][41 -50][-41 -50][42 -50][-42 -50][43 -50][-43 -50][44 -50][-44 -50][45 -50][-45 -50][46 -50][-46 -50][47 -50][-47 -50][48 -50][-48 -50][49 -50][-49 -50][50 -50]] [ set pcolor 102 ]]

end

to customers_move
  ask male_customers [
    if (color != 15) and (color != 25) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 0 ) [
      set current-target-patch (one-of patches with [pcolor = 54.01])
       if (count turtles-on (current-target-patch) > 0)[
        set current-target-patch (one-of patches with [pcolor = 54.01])]
    face (current-target-patch)
    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
       ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
      ] ]]]]
      if  [pcolor] of patch-here = 54.01 [
          set time_in_stage_area time_in_stage_area + 1]]]


  ask female_customers [
    if (color != 15)  and (color != 25) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 0 )  [
      set current-target-patch (one-of patches with [pcolor = 54.01])
       if (count turtles-on (current-target-patch) > 0)[
        set current-target-patch (one-of patches with [pcolor = 54.01])]
    face (current-target-patch)
    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
      ]
      ]
  ]]
      if  [pcolor] of patch-here = 54.01 [
          set time_in_stage_area time_in_stage_area + 1]]]]
end

to thirsty_customer
   ask male_customers[
    if (color = 105) and ([pcolor] of patch-here = 54.01 and (time_in_stage_area > random-poisson 30))  and (( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 0 )) and (count turtles with [color = 15] <= (1.5 * pocet_napojovych_stanku))  [
    set color 15 ] ]

     ask male_customers[
    if (color = 105) and ([pcolor] of patch-here = 54.01 and (time_in_stage_area > random-poisson 120))  and (( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 0 )) and (count turtles with [color = 15] > (1.5 * pocet_napojovych_stanku))  [
    set color 15 ] ]

     ask female_customers[
    if (color = 135) and([pcolor] of patch-here = 54.01 and (time_in_stage_area > random-poisson 45))  and (( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 0 )) and (count turtles with [color = 15] <= (1.5 * pocet_napojovych_stanku))  [
    set color 15] ]

     ask female_customers[
    if (color = 135) and([pcolor] of patch-here = 54.01 and (time_in_stage_area > random-poisson 180))  and (( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 0 )) and (count turtles with [color = 15] > (1.5 * pocet_napojovych_stanku))  [
    set color 15] ]
end


to thirsty_customer_move
  ask male_customers [

 if (color = 15) and ([pcolor] of patch-here != 45) and ([pcolor] of current-target-patch = 54.01)  and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 ) [
      set my_drink min-one-of patches with [pcolor = 45] [distance myself]
      set my-drink distance my_drink
      set current-target-patch (my_drink)
      face (current-target-patch)


    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
    ]]]]]]

    if (color = 15) and ([pcolor] of patch-here != 45) and ([pcolor] of current-target-patch = 45) and (count turtles-on (current-target-patch) = 0)  and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[

      face (current-target-patch)

    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
    ]]]]]]

  if (color = 15) and ([pcolor] of patch-here != 45) and ([pcolor] of current-target-patch = 45) and (count turtles-on (current-target-patch) > 0)  and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[

    if xcor <= 0 [
        if pocet_napojovych_stanku <= 10 [facexy 40 -1]
          if pocet_napojovych_stanku > 10 and pocet_napojovych_stanku <= 20 [ facexy -40 -3]
          if pocet_napojovych_stanku > 20 and pocet_napojovych_stanku <= 30 [ facexy -40 -8]
          if pocet_napojovych_stanku > 30 and pocet_napojovych_stanku <= 40 [ facexy -40 -13]
          if pocet_napojovych_stanku > 40 and pocet_napojovych_stanku <= 50 [ facexy -40 -18]
          if pocet_napojovych_stanku > 50 and pocet_napojovych_stanku <= 60 [ facexy -40 -20]
          if pocet_napojovych_stanku > 60 and pocet_napojovych_stanku <= 70 [ facexy -40 -20]
          if pocet_napojovych_stanku > 70 and pocet_napojovych_stanku <= 80 [ facexy -40 -20]
          if pocet_napojovych_stanku > 80 and pocet_napojovych_stanku <= 90 [ facexy -40 -20]
          if pocet_napojovych_stanku > 90 and pocet_napojovych_stanku <= 100 [ facexy -40 -20]


    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
      ]]]]

        set my_drink min-one-of patches with [pcolor = 45] [distance myself]
        set my-drink distance my_drink
        set current-target-patch (my_drink)]]

     if xcor > 0 [

        if pocet_napojovych_stanku <= 10 [facexy 40 -1]
        if pocet_napojovych_stanku > 10 and pocet_napojovych_stanku <= 20 [ facexy 40 -3]
        if pocet_napojovych_stanku > 20 and pocet_napojovych_stanku <= 30 [ facexy 40 -8]
        if pocet_napojovych_stanku > 30 and pocet_napojovych_stanku <= 40 [ facexy 40 -13]
        if pocet_napojovych_stanku > 40 and pocet_napojovych_stanku <= 50 [ facexy 40 -18]
        if pocet_napojovych_stanku > 50 and pocet_napojovych_stanku <= 60 [ facexy 40 -20]
        if pocet_napojovych_stanku > 60 and pocet_napojovych_stanku <= 70 [ facexy 40 -20]
        if pocet_napojovych_stanku > 70 and pocet_napojovych_stanku <= 80 [ facexy 40 -20]
        if pocet_napojovych_stanku > 80 and pocet_napojovych_stanku <= 90 [ facexy 40 -20]
        if pocet_napojovych_stanku > 90 and pocet_napojovych_stanku <= 100 [ facexy 40 -20]


    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
      ]]]]

        set my_drink min-one-of patches with [pcolor = 45] [distance myself]
        set my-drink distance my_drink
          set current-target-patch (my_drink)]]]]

  ask female_customers [

    if (color = 15) and ([pcolor] of patch-here != 45) and ([pcolor] of current-target-patch = 54.01) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 ) [
      set my_drink min-one-of patches with [pcolor = 45] [distance myself]
      set my-drink distance my_drink
      set current-target-patch (my_drink)
      face (current-target-patch)


    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
    ]]]]]]

    if (color = 15) and ([pcolor] of patch-here != 45) and ([pcolor] of current-target-patch = 45) and (count turtles-on (current-target-patch) = 0)  and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[

      face (current-target-patch)

    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
    ]]]]]]

  if (color = 15) and ([pcolor] of patch-here != 45) and ([pcolor] of current-target-patch = 45) and (count turtles-on (current-target-patch) > 0)  and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[

    if xcor <= 0 [
        if pocet_napojovych_stanku <= 10 [facexy 40 -1]
          if pocet_napojovych_stanku > 10 and pocet_napojovych_stanku <= 20 [ facexy -40 -3]
          if pocet_napojovych_stanku > 20 and pocet_napojovych_stanku <= 30 [ facexy -40 -8]
          if pocet_napojovych_stanku > 30 and pocet_napojovych_stanku <= 40 [ facexy -40 -13]
          if pocet_napojovych_stanku > 40 and pocet_napojovych_stanku <= 50 [ facexy -40 -18]
          if pocet_napojovych_stanku > 50 and pocet_napojovych_stanku <= 60 [ facexy -40 -20]
          if pocet_napojovych_stanku > 60 and pocet_napojovych_stanku <= 70 [ facexy -40 -20]
          if pocet_napojovych_stanku > 70 and pocet_napojovych_stanku <= 80 [ facexy -40 -20]
          if pocet_napojovych_stanku > 80 and pocet_napojovych_stanku <= 90 [ facexy -40 -20]
          if pocet_napojovych_stanku > 90 and pocet_napojovych_stanku <= 100 [ facexy -40 -20]


    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
      ]]]]

        set my_drink min-one-of patches with [pcolor = 45] [distance myself]
        set my-drink distance my_drink
        set current-target-patch (my_drink)]]

     if xcor > 0 [

        if pocet_napojovych_stanku <= 10 [facexy 40 -1]
        if pocet_napojovych_stanku > 10 and pocet_napojovych_stanku <= 20 [ facexy 40 -3]
        if pocet_napojovych_stanku > 20 and pocet_napojovych_stanku <= 30 [ facexy 40 -8]
        if pocet_napojovych_stanku > 30 and pocet_napojovych_stanku <= 40 [ facexy 40 -13]
        if pocet_napojovych_stanku > 40 and pocet_napojovych_stanku <= 50 [ facexy 40 -18]
        if pocet_napojovych_stanku > 50 and pocet_napojovych_stanku <= 60 [ facexy 40 -20]
        if pocet_napojovych_stanku > 60 and pocet_napojovych_stanku <= 70 [ facexy 40 -20]
        if pocet_napojovych_stanku > 70 and pocet_napojovych_stanku <= 80 [ facexy 40 -20]
        if pocet_napojovych_stanku > 80 and pocet_napojovych_stanku <= 90 [ facexy 40 -20]
        if pocet_napojovych_stanku > 90 and pocet_napojovych_stanku <= 100 [ facexy 40 -20]


    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
      ]]]]

        set my_drink min-one-of patches with [pcolor = 45] [distance myself]
        set my-drink distance my_drink
          set current-target-patch (my_drink)]]]]
end

to waiting_customer
  ask male_customers[
    if (color = 15) and ([pcolor] of patch-here = 54.03) [
      set waiting_time waiting_time + 1]]
  ask female_customers[
    if (color = 15) and ([pcolor] of patch-here = 54.03) [
      set waiting_time waiting_time + 1]]
  ask male_customers[
    if (color = 25) and ([pcolor] of patch-here = 54.03) [
      set waiting_time waiting_time + 1]]
  ask female_customers[
    if (color = 25) and ([pcolor] of patch-here = 54.03) [
      set waiting_time waiting_time + 1]]

end

to thirsty_waiting_customer
  ask male_customers  [
    if ([pcolor] of patch-here = 45) and (color = 15) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[
      set count-down_drink count-down_drink - 1
         if count-down_drink = 0 [
              if waiting_time > 30 [
                     set unhappy_index unhappy_index + 1]
            set count_of_drinks count_of_drinks + 1
            set ticks-since-here 0
            set color 105
            set time_in_stage_area 0
            set count-down_drink 3
            set waiting_time -15
            set total_drinks total_drinks + 1
        ask patch-here [ set pocet_navstevniku_na_poli pocet_navstevniku_na_poli + 1]
        customers_move
      ] ]]

  ask female_customers  [
    if ([pcolor] of patch-here = 45) and (color = 15) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[
      set count-down_drink count-down_drink - 1
         if count-down_drink = 0 [
            if waiting_time > 30 [
               set unhappy_index unhappy_index + 1]
            set count_of_drinks count_of_drinks + 1
            set ticks-since-here 0
            set color 135
            set time_in_stage_area 0
            set count-down_drink 3
            set waiting_time -15
            set total_drinks total_drinks + 1
            ask patch-here [set pocet_navstevniku_na_poli pocet_navstevniku_na_poli + 1]
            customers_move
      ] ]]
end



to waiting_area
  ask patches with [pcolor = 45][
    ask patches in-radius 15 [
      set pcolor 54.03
    ]
  ]
  ask patches with [pcolor = 102][
    ask patches in-radius 15 [
      set pcolor 54.03
    ]
  ]
end

to set-unhappy_customers
  ask male_customers [
    if (unhappy_index = 7)[
      set unhappy_male_customer "YES"]]
    ask female_customers [
    if (unhappy_index = 5)[
      set unhappy_female_customer "YES"]]
end

to setup-end_of_festival
  ask male_customers [
    if (color = 105) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) >= 0 ) and ([pcolor] of patch-here != 54.04) and (([pcolor] of current-target-patch = 54.01) or ([pcolor] of current-target-patch = 45) or ([pcolor] of current-target-patch = 102) or ([pcolor] of current-target-patch = 54.08))  [
      set my_exit min-one-of patches with [pcolor = 54.04] [distance myself]
      set my-exit distance my_exit
      set current-target-patch (my_exit)
      face (current-target-patch)

 ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace ] ] ]]]]

     if (color = 105) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) >= 0 ) and ([pcolor] of patch-here != 54.04) and ([pcolor] of current-target-patch = 54.04) [

      face (current-target-patch)

     ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace] [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace] [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace] [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace ] ]  ]]]]

    if (color = 105) and ([pcolor] of patch-here = 54.04) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) >= 0 )[
      ask self [
        if unhappy_male_customer = "YES" [
          ask patch-here [set pocet_nespokojenych_zakazniku pocet_nespokojenych_zakazniku + 1]]
          set-unhappy_customers
        die]]


  if ((color = 15) or (color = 25)) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) >= 120 ) and ([pcolor] of patch-here != 54.04)  [
      set my_exit min-one-of patches with [pcolor = 54.04] [distance myself]
      set my-exit distance my_exit
      set current-target-patch (my_exit)
      face (current-target-patch)

 ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace ] ] ]]]]

  if ((color = 15) or (color = 25)) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) >= 120 ) and ([pcolor] of patch-here != 54.04) and ([pcolor] of current-target-patch = 54.04) [

      face (current-target-patch)

     ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace] [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace] [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace] [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace ] ]  ]]]]

  if ((color = 15) or (color = 25)) and ([pcolor] of patch-here = 54.04) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) >= 120 ) [
      ask self [
      set unhappy_index unhappy_index + 4

        if unhappy_male_customer = "YES" [
          ask patch-here [set pocet_nespokojenych_zakazniku pocet_nespokojenych_zakazniku + 1]]
        set-unhappy_customers
      die]]]




    ask female_customers [
    if (color = 135) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) >= 0 ) and ([pcolor] of patch-here != 54.04) and (([pcolor] of current-target-patch = 54.01) or ([pcolor] of current-target-patch = 45) or ([pcolor] of current-target-patch = 102)  or ([pcolor] of current-target-patch = 54.08))  [
      set my_exit min-one-of patches with [pcolor = 54.04] [distance myself]
      set my-exit distance my_exit
      set current-target-patch (my_exit)
      face (current-target-patch)

   ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace ] ] ]]]]

    if (color = 135) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) >= 0 ) and ([pcolor] of patch-here != 54.04) and ([pcolor] of current-target-patch = 54.04) [

      face (current-target-patch)

     ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace] [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace] [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace] [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace ] ]  ]]]]

    if (color = 135) and ([pcolor] of patch-here = 54.04) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) >= 0 )[
      ask self [
        if unhappy_female_customer = "YES" [
          ask patch-here [set pocet_nespokojenych_zakazniku pocet_nespokojenych_zakazniku + 1]]
        set-unhappy_customers
        die]]


  if ((color = 15) or (color = 25)) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) >= 120 ) and ([pcolor] of patch-here != 54.04)  [
      set my_exit min-one-of patches with [pcolor = 54.04] [distance myself]
      set my-exit distance my_exit
      set current-target-patch (my_exit)
      face (current-target-patch)

 ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace ] ] ]]]]

  if ((color = 15) or (color = 25)) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) >= 120 ) and ([pcolor] of patch-here != 54.04) and ([pcolor] of current-target-patch = 54.04) [

      face (current-target-patch)

     ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace] [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace] [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace] [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace ] ]  ]]]]

  if ((color = 15) or (color = 25)) and ([pcolor] of patch-here = 54.04) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) >= 120 ) [
      ask self [
      set unhappy_index unhappy_index + 4
        if unhappy_female_customer = "YES" [
          ask patch-here [set pocet_nespokojenych_zakazniku pocet_nespokojenych_zakazniku + 1]]
        set-unhappy_customers
      die]]]


end



to needtopee_customer
   ask male_customers[
       if [pcolor] of patch-here = 54.01 and ((count_of_drinks * 500) * (random-poisson 0.20)  > random-normal 350 50)  and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 0 ) and (count turtles with [color = 25] <= (2 * pocet_TOITOI)) [
       set color 25
       set my_TOI min-one-of patches with [pcolor = 102] [distance myself]
       set my-TOI distance my_TOI
       set current-target-patch (my_TOI)] ]

     ask male_customers[
       if [pcolor] of patch-here = 54.01 and ((count_of_drinks * 500) * (random-poisson 0.20)  > random-normal 450 50)  and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 0 ) and (count turtles with [color = 25] > (2 * pocet_TOITOI))  [
       set color 25
       set my_TOI min-one-of patches with [pcolor = 102] [distance myself]
       set my-TOI distance my_TOI
       set current-target-patch (my_TOI)] ]

    ask female_customers[
       if [pcolor] of patch-here = 54.01 and ((count_of_drinks * 500 ) * (random-poisson 0.15)  > random-normal 200 50)  and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 0 ) and (count turtles with [color = 25] <= (2 * pocet_TOITOI))  [
       set color 25
       set my_TOI min-one-of patches with [pcolor = 102] [distance myself]
       set my-TOI distance my_TOI
      set current-target-patch (my_TOI)] ]

    ask female_customers[
       if [pcolor] of patch-here = 54.01 and ((count_of_drinks * 500 ) * (random-poisson 0.15)  > random-normal 300 50)  and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 0 ) and (count turtles with [color = 25] > (2 * pocet_TOITOI))[
       set color 25
       set my_TOI min-one-of patches with [pcolor = 102] [distance myself]
       set my-TOI distance my_TOI
      set current-target-patch (my_TOI)] ]


end



to needtopee_customer_move
  ask male_customers [
      if (color = 25) and ([pcolor] of patch-here != 102) and ([pcolor] of current-target-patch = 102) and (count turtles-on (current-target-patch) = 0) and (waiting_time <= 90) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[

      face (current-target-patch)
    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
    ]]]]]]

  if (color = 25) and ([pcolor] of patch-here != 102) and ([pcolor] of current-target-patch = 102) and (count turtles-on (current-target-patch) > 0)  and (waiting_time <= 90) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 ) [

    if xcor <= 0 [
        if pocet_TOITOI <= 10 [facexy 2 -35]
        if pocet_TOITOI > 10 and pocet_TOITOI <= 20 [ facexy 8 -35]
        if pocet_TOITOI > 20 and pocet_TOITOI <= 30 [ facexy 10 -35]
        if pocet_TOITOI > 30 and pocet_TOITOI <= 40 [ facexy 13 -35]
        if pocet_TOITOI > 40 and pocet_TOITOI <= 50 [ facexy 19 -35]
        if pocet_TOITOI > 50 and pocet_TOITOI <= 60 [ facexy 24 -35]
        if pocet_TOITOI > 60 and pocet_TOITOI <= 70 [ facexy 28 -35]
        if pocet_TOITOI > 70 and pocet_TOITOI <= 80 [ facexy 33 -35]
        if pocet_TOITOI > 80 and pocet_TOITOI <= 90 [ facexy 39 -35]
        if pocet_TOITOI > 90 and pocet_TOITOI <= 100 [ facexy 40 -35]

    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
    ]]]]]
        set my_TOI min-one-of patches with [pcolor = 102] [distance myself]
        set my-TOI distance my_TOI
        set current-target-patch (my_TOI)]

     if xcor > 0 [

        if pocet_TOITOI <= 10 [facexy -2 -35]
        if pocet_TOITOI > 10 and pocet_TOITOI <= 20 [ facexy -8 -35]
        if pocet_TOITOI > 20 and pocet_TOITOI <= 30 [ facexy -10 -35]
        if pocet_TOITOI > 30 and pocet_TOITOI <= 40 [ facexy -13 -35]
        if pocet_TOITOI > 40 and pocet_TOITOI <= 50 [ facexy -19 -35]
        if pocet_TOITOI > 50 and pocet_TOITOI <= 60 [ facexy -24 -35]
        if pocet_TOITOI > 60 and pocet_TOITOI <= 70 [ facexy -28 -35]
        if pocet_TOITOI > 70 and pocet_TOITOI <= 80 [ facexy -33 -35]
        if pocet_TOITOI > 80 and pocet_TOITOI <= 90 [ facexy -39 -35]
        if pocet_TOITOI > 90 and pocet_TOITOI <= 100 [ facexy -40 -35]


    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
    ]]]]]
        set my_TOI min-one-of patches with [pcolor = 102] [distance myself]
        set my-TOI distance my_TOI
        set current-target-patch (my_TOI)]]]

  ask female_customers [
      if (color = 25) and ([pcolor] of patch-here != 102) and ([pcolor] of current-target-patch = 102) and (count turtles-on (current-target-patch) = 0)  and (waiting_time <= 45)  and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[

      face (current-target-patch)
    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
    ]]]]]]

  if (color = 25) and ([pcolor] of patch-here != 102) and ([pcolor] of current-target-patch = 102) and (count turtles-on (current-target-patch) > 0)  and (waiting_time <= 45) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 ) [

    if xcor < 0 [
        if pocet_TOITOI <= 10 [facexy -2 -35]
        if pocet_TOITOI > 10 and pocet_TOITOI <= 20 [ facexy -8 -35]
        if pocet_TOITOI > 20 and pocet_TOITOI <= 30 [ facexy -10 -35]
        if pocet_TOITOI > 30 and pocet_TOITOI <= 40 [ facexy -13 -35]
        if pocet_TOITOI > 40 and pocet_TOITOI <= 50 [ facexy -19 -35]
        if pocet_TOITOI > 50 and pocet_TOITOI <= 60 [ facexy -24 -35]
        if pocet_TOITOI > 60 and pocet_TOITOI <= 70 [ facexy -28 -35]
        if pocet_TOITOI > 70 and pocet_TOITOI <= 80 [ facexy -33 -35]
        if pocet_TOITOI > 80 and pocet_TOITOI <= 90 [ facexy -39 -35]
        if pocet_TOITOI > 90 and pocet_TOITOI <= 100 [ facexy -40 -35]

    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
    ]]]]]
        set my_TOI min-one-of patches with [pcolor = 102] [distance myself]
        set my-TOI distance my_TOI
        set current-target-patch (my_TOI)]

      if xcor = 0 [
        set current-target-patch one-of patches with [pcolor = 102]
        face (current-target-patch)
    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace ]]]]] ]

     if xcor > 0 [

        if pocet_TOITOI <= 10 [facexy 2 -35]
        if pocet_TOITOI > 10 and pocet_TOITOI <= 20 [ facexy 8 -35]
        if pocet_TOITOI > 20 and pocet_TOITOI <= 30 [ facexy 10 -35]
        if pocet_TOITOI > 30 and pocet_TOITOI <= 40 [ facexy 13 -35]
        if pocet_TOITOI > 40 and pocet_TOITOI <= 50 [ facexy 19 -35]
        if pocet_TOITOI > 50 and pocet_TOITOI <= 60 [ facexy 24 -35]
        if pocet_TOITOI > 60 and pocet_TOITOI <= 70 [ facexy 28 -35]
        if pocet_TOITOI > 70 and pocet_TOITOI <= 80 [ facexy 33 -35]
        if pocet_TOITOI > 80 and pocet_TOITOI <= 90 [ facexy 39 -35]
        if pocet_TOITOI > 90 and pocet_TOITOI <= 100 [ facexy 40 -35]


    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace
    ]]]]]
        set my_TOI min-one-of patches with [pcolor = 102] [distance myself]
        set my-TOI distance my_TOI
        set current-target-patch (my_TOI)]]]
end


to needtopee_waiting_customer
  ask male_customers  [
    if ([pcolor] of patch-here = 102) and (color = 25) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[
      set count-down_TOI count-down_TOI - 1

        if count-down_TOI = 0 [
              if waiting_time > 30 [
                     set unhappy_index unhappy_index + 1]
            set count_of_drinks 0
            set ticks-since-here 0
            set color 105
            set time_in_stage_area 0
            set count-down_TOI 3
            set waiting_time -15
            ask patch-here [set pocet_navstevniku_na_poli pocet_navstevniku_na_poli + 1]
            customers_move] ]
   if ([pcolor] of patch-here = 54.08) and (color = 25) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[
      set count-down_TOI count-down_TOI - 1

        if count-down_TOI = 0 [
            set unhappy_index unhappy_index + 3
            set count_of_drinks 0
            set ticks-since-here 0
            set color 105
            set time_in_stage_area 0
            set count-down_TOI 3
            set waiting_time -15
            ask patch-here [set pocet_navstevniku_na_poli pocet_navstevniku_na_poli + 1]
            customers_move] ]]
  ask female_customers  [
    if ([pcolor] of patch-here = 102) and (color = 25) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[
      set count-down_TOI count-down_TOI - 1

        if count-down_TOI = 0 [
              if waiting_time > 30 [
                     set unhappy_index unhappy_index + 1]
            set count_of_drinks 0
            set ticks-since-here 0
            set color 135
            set time_in_stage_area 0
            set count-down_TOI 5
            set waiting_time -15
            ask patch-here [set pocet_navstevniku_na_poli pocet_navstevniku_na_poli + 1]
            customers_move] ]
      if ([pcolor] of patch-here = 54.08) and (color = 25) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[
      set count-down_TOI count-down_TOI - 1

        if count-down_TOI = 0 [
            set unhappy_index unhappy_index + 4
            set count_of_drinks 0
            set ticks-since-here 0
            set color 135
            set time_in_stage_area 0
            set count-down_TOI 5
            set waiting_time -15
            ask patch-here [set pocet_navstevniku_na_poli pocet_navstevniku_na_poli + 1]
            customers_move] ]]
end

to free_pee_customers
  ask male_customers [
    if (color = 25) and ([pcolor] of patch-here != 102) and ([pcolor] of current-target-patch = 102) and (waiting_time > 90) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[
       set my_TOI min-one-of patches with [pcolor = 54.08] [distance myself]
       set my-TOI distance my_TOI
       set current-target-patch (my_TOI)
      face (current-target-patch)

    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
                  jump pace ]]]]]]


    if (color = 25) and (([pcolor] of patch-here != 102) or ([pcolor] of patch-here != 54.08)) and ([pcolor] of current-target-patch = 54.08) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[

       set my_TOI min-one-of patches with [pcolor = 102] [distance myself]
       set my-TOI distance my_TOI
       set current-target-patch (my_TOI)

      if (count turtles-on (current-target-patch) = 0) [
      face (current-target-patch)
    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace] [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace] [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace] [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
                  jump pace ]]]]]]]

     if (color = 25) and (([pcolor] of patch-here != 102) or ([pcolor] of patch-here != 54.08)) and ([pcolor] of current-target-patch = 54.08) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[
       set my_TOI min-one-of patches with [pcolor = 102] [distance myself]
       set my-TOI distance my_TOI
       set current-target-patch (my_TOI)

      if count turtles-on (current-target-patch) > 0[
       set my_TOI min-one-of patches with [pcolor = 54.04] [distance myself]
       set my-TOI distance my_TOI
       set current-target-patch (my_TOI)
       face (current-target-patch)
    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace ]]]]]]
      ]]

ask female_customers [
     if (color = 25) and ([pcolor] of patch-here != 102) and ([pcolor] of current-target-patch = 102) and (waiting_time > 45) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[
       set my_TOI min-one-of patches with [pcolor = 54.08] [distance myself]
       set my-TOI distance my_TOI
       set current-target-patch (my_TOI)
      face (current-target-patch)

    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
                  jump pace ]]]]]]


    if (color = 25) and (([pcolor] of patch-here != 102) or ([pcolor] of patch-here != 54.08)) and ([pcolor] of current-target-patch = 54.08) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[
       set my_TOI min-one-of patches with [pcolor = 102] [distance myself]
       set my-TOI distance my_TOI
       set current-target-patch (my_TOI)

      if count turtles-on (current-target-patch) = 0[
        face (current-target-patch)
    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
                  jump pace ]]]]]]]

     if (color = 25) and (([pcolor] of patch-here != 102) or ([pcolor] of patch-here != 54.08)) and ([pcolor] of current-target-patch = 54.08) and ( ticks  - (60 * (konec_festivalu - zacatek_festivalu)) < 120 )[
       set my_TOI min-one-of patches with [pcolor = 102] [distance myself]
       set my-TOI distance my_TOI
       set current-target-patch (my_TOI)

      if count turtles-on (current-target-patch) > 0[
       set my_TOI min-one-of patches with [pcolor = 54.04] [distance myself]
       set my-TOI distance my_TOI
       set current-target-patch (my_TOI)
       face (current-target-patch)
    ifelse (patch-ahead pace != nobody) and ((not any? turtles-on patch-ahead pace) or
    ((count turtles-on patch-ahead pace = 1) and
      (one-of turtles-on patch-ahead pace = self))) and ([pcolor] of patch-ahead pace != 1) [
        jump pace]
    [
      ifelse (patch-right-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 45 pace) or
    ((count turtles-on patch-right-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 45 pace = self))) and ([pcolor] of patch-right-and-ahead 45 pace != 1)  [
        right  45
        jump pace]  [
    ifelse (patch-left-and-ahead 45 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 45 pace) or
    ((count turtles-on patch-left-and-ahead 45 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 45 pace = self))) and ([pcolor] of patch-left-and-ahead 45 pace != 1)  [
        left  45
        jump pace
        ][
      ifelse (patch-right-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-right-and-ahead 95 pace) or
    ((count turtles-on patch-right-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-right-and-ahead 95 pace = self))) and ([pcolor] of patch-right-and-ahead 95 pace != 1)  [
        right  95
        jump pace]  [
    if (patch-left-and-ahead 95 pace != nobody) and ((not any? turtles-on patch-left-and-ahead 95 pace) or
    ((count turtles-on patch-left-and-ahead 95 pace = 1) and
      (one-of turtles-on patch-left-and-ahead 95 pace = self))) and ([pcolor] of patch-left-and-ahead 95 pace != 1)  [
        left  95
        jump pace ]]]]]]
    ]]
end
@#$#@#$#@
GRAPHICS-WINDOW
232
13
963
745
-1
-1
7.16
1
100
1
1
1
0
0
0
1
-50
50
-50
50
1
1
1
minuty
30.0

BUTTON
48
20
165
53
Načíst simulaci
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
48
63
166
96
Spustit festival
Start
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

INPUTBOX
13
230
209
290
Pocet_navstevniku
2500.0
1
0
Number

MONITOR
1418
672
1531
717
Muzsti navstevnici
count male_customers
17
1
11

MONITOR
1417
621
1529
666
Zensti navstevnici
count female_customers
17
1
11

SLIDER
11
372
207
405
Pocet_napojovych_stanku
Pocet_napojovych_stanku
1
100
72.0
1
1
NIL
HORIZONTAL

PLOT
974
78
1405
327
Počečet čkajících na nápoj
Čas
Počet návštěvníků
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"Všichni zákazníci" 1.0 0 -16777216 true "" "plot count turtles \nwith [(color = 15) and ([pcolor] of patch-here = 54.03)]\n"
"Muži" 1.0 0 -14070903 true "" "plot count male_customers \nwith [(color = 15) and ([pcolor] of patch-here = 54.03)]\n"
"Ženy" 1.0 0 -5825686 true "" "plot count female_customers \nwith [(color = 15) and ([pcolor] of patch-here = 54.03)]\n"

PLOT
1412
78
1843
328
Průměrná doba čekání na nápoj
Průběh festivalu (čas)
Průměrná doba čekání
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"Všichni zákazníci" 1.0 0 -16777216 true "" "plot mean [waiting_time] of turtles with [color = 15]"
"Muži" 1.0 0 -14730904 true "" "plot mean [waiting_time] of male_customers with [color = 15]"
"Ženy" 1.0 0 -5825686 true "" "plot mean [waiting_time] of female_customers with [color = 15]"

SLIDER
11
296
208
329
Zacatek_festivalu
Zacatek_festivalu
10
18
17.0
1
1
: 00 hodin
HORIZONTAL

SLIDER
11
334
208
367
Konec_festivalu
Konec_festivalu
19
23
22.0
1
1
: 00 hodin
HORIZONTAL

MONITOR
70
128
143
173
Aktuální čas
Zacatek_festivalu + (ticks / 60 )
2
1
11

SLIDER
11
411
207
444
Pocet_TOITOI
Pocet_TOITOI
1
100
67.0
1
1
TOI TOI
HORIZONTAL

PLOT
975
333
1405
583
Počet čekajících na vykonání potřeby
Čas
Počet návštěvníků
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"Všichni" 1.0 0 -16777216 true "" "plot count turtles with [color = 25]"
"Ženy" 1.0 0 -5825686 true "" "plot count female_customers with [color = 25]"
"Muži" 1.0 0 -14070903 true "" "plot count male_customers with [color = 25]"

PLOT
1413
333
1841
582
Průměrná doba čekání na TOI TOI
Průběh festivalu (čas)
Průměrná doba čekání
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"Ženy" 1.0 0 -5825686 true "" "plot mean [waiting_time] of female_customers with [color = 25]"
"Muži" 1.0 0 -14070903 true "" "plot mean [waiting_time] of male_customers with [color = 25]"
"Všichni zákazníci" 1.0 0 -16777216 true "" "plot mean [waiting_time] of turtles with [color = 25]"

MONITOR
44
536
181
581
Počet prodaných nápojů
sum [pocet_navstevniku_na_poli] of patches with [pcolor = 45]
17
1
11

MONITOR
43
586
181
631
Počet použitých TOI TOI
sum [pocet_navstevniku_na_poli] of patches with [pcolor = 102]
17
1
11

MONITOR
8
636
216
681
Počet návštěvníků obcházejících pravidla
sum [pocet_navstevniku_na_poli] of patches with [pcolor = 54.08]
17
1
11

TEXTBOX
1027
34
1214
52
Návštěvnice (ženy) festivalu
12
125.0
1

TEXTBOX
1001
10
1195
28
Grafické znázornění simulace:
15
0.0
1

TEXTBOX
1213
34
1363
52
Návštěvníci (muži) festivalu
12
105.0
1

TEXTBOX
1392
34
1542
52
Všichni zákazníci
12
0.0
1

TEXTBOX
1014
35
1029
75
°
16
0.0
1

TEXTBOX
1197
35
1212
53
°
16
0.0
1

TEXTBOX
1382
35
1397
53
°
16
0.0
1

TEXTBOX
24
508
217
548
Výstupní hodnoty modelu:
15
0.0
1

TEXTBOX
25
198
205
236
Vstupní parametry modelu:
15
0.0
1

TEXTBOX
992
623
1142
641
Legenda modelu:
13
0.0
1

TEXTBOX
1032
642
1127
660
Nápojové stánky
11
0.0
1

TEXTBOX
1033
662
1069
680
Pódium
11
0.0
1

TEXTBOX
1032
684
1080
702
TOI TOI
11
0.0
1

TEXTBOX
1009
574
1134
674
.
80
45.0
1

TEXTBOX
1009
594
1159
691
.
80
0.0
1

TEXTBOX
1009
618
1159
698
.
80
102.0
1

TEXTBOX
1177
634
1327
652
Ženy
11
0.0
1

TEXTBOX
1178
654
1328
672
Muži
11
0.0
1

TEXTBOX
1178
676
1328
694
Žíznivý zákazník
11
0.0
1

TEXTBOX
1179
697
1353
725
Zákazník potřebující na TOI TOI
11
0.0
1

TEXTBOX
1164
630
1179
649
!
15
135.0
1

TEXTBOX
1164
650
1179
669
!
15
105.0
1

TEXTBOX
1164
673
1179
692
!
15
15.0
1

TEXTBOX
1163
694
1178
713
!
15
25.0
1

TEXTBOX
1034
701
1184
719
Východ
11
0.0
1

TEXTBOX
1001
683
1033
723
. .
30
0.0
1

MONITOR
18
686
205
731
Počet nespokojených zákazníků
sum [pocet_nespokojenych_zakazniku] of patches with [pcolor = 54.04]
17
1
11

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
