; atheisti = green
; lutherani = black
; katolici = yellow

__includes ["katolici.nls" "reporty.nls"]
; v souboru katolici.nls je setup vsech katoliku
; v souboru reporty.nls jsou vsechny reportovaci veci

globals [
  self-converted-catholics-to-atheism ; kolik katoliku samo "konvertovalo" k atheismu
  self-converted-lutherans-to-atheism ; kolik lutheranu samo "konvertovalo" k atheismu
  born-lutheran ; narozeni luterani
  born-catholic ; narozeni katolici
  born-atheist ; narozeni ateiste
  persuaded-catholics ; konvertovani katolici
  persuaded-lutherans ; konvertovani luterani
  tydny ; pocitadlo tydnu
  i-see-dead-people ; pocet mrtvych
]

breed [ lutherans lutheran ] ;tady jsou jediny breed luterani, zbytek je v dalsim souboru

turtles-own [ age gender population-growth lutheran? catholic? atheist? converted? home-color datum-konverze prispevek home-type]
; vek neni treba vysvetlovat
; gender taky ne
; lutheran, catholic a atheist drzi value toho, jake nabozenstvi v soucasnu dany clovek vyznava
; converted? znaci, zda byl clovek od spusteni simulace konvertovan (cath -> luth a vice versa) -- predpoklad, ze clovek takhle za zivot konvertuje jenom jednou a zpet uz se vracet nebude, nota bene v 16. stoleti
; home-color je barva domaciho uzemi, pouzita pro srovnani pri pohybu (mala sance na migraci mimo domov)
; datum-konverze je cislo ticku/tydne, kdy doslo ke konverzi daneho cloveka na "druhou stranu" -- pokud clovek konvertuje, asi mu chvili potrva, nez vubec zacne premyslet o atheismu
; je to celkem mekke, ale za me docela zajimava vec
; prispevek - velikost prispevku na chod imperia
; home-type -

to setup
  clear-all
  reset-globals
  import-pcolors "nemecko.png"
  set-default-shape turtles "person"

  setup-catholics
  luterani

  reset-ticks
end


to go
  if all? turtles [ lutheran? ]
      [ stop ]

  ask turtles with [ lutheran? and age > 14 * 52  ] [ ; minimalni vek pro nejake presvedcovani je 14
    persuade-catholics
  ]
  ask turtles with [ catholic? and age > 14 * 52 ] [
    persuade-lutherans
  ]
  ask turtles with [ not lutheran? ] [
    move-non-lutheran 0.5
  ]
  ask turtles with [ lutheran? ] [
    move-lutheran rychlost-sireni
  ]
  ask turtles [
      reevaluate-religion
      reproduce (14 * 52) population-growth
      die-for-reasons
      set age age + 1
  ]
  week-counter
  tick
end

to reset-globals ; resetovani globalnich promennych
  set self-converted-catholics-to-atheism 0
  set self-converted-lutherans-to-atheism 0
  set born-lutheran 0
  set born-catholic 0
  set born-atheist 0
  set persuaded-catholics 0
  set persuaded-lutherans 0
  set tydny 0
end



to move-non-lutheran [ dist ] ; pohyb neluterana
  right random 30
  left random 30

  let turn one-of [ -50 50 ]
  while [
    [ pcolor ] of patch-ahead 1 = 20  or
    [ pcolor ] of patch-ahead 1 = 98]
  [
    set heading heading + turn
  ]
   if [ pcolor ] of patch-ahead 1 != home-color [
   if random-float 100 < cestovatelske-choutky [ forward dist ]
  ]
  if [ pcolor ] of patch-ahead 1 = home-color [
  forward dist
  ]
end

to move-lutheran [ dist ] ; pohyb luterana
  right random 30
  left random 30

  let turn one-of [ -50 50 ]
  while [
    [ pcolor ] of patch-ahead 1 = 20  or
    [ pcolor ] of patch-ahead 1 = 98]
  [
    set heading heading + turn
  ]
   if [ pcolor ] of patch-ahead 1 != home-color [
   if random-float 100 < nadseni-pro-martina [ forward dist ]
  ]
  if [ pcolor ] of patch-ahead 1 = home-color [
  forward dist
  ]
end

to luterani ;nastaveni luteranu
  create-lutherans pocet-luteranu [
    set-age
    set-gender
    set-lutheranism
    set home-color 18
    set converted? false
    set population-growth 1.0000
    move-to one-of patches with [ pcolor = 18 ]
  ]
end

to reproduce [ min-age mira-rozrustani ] ; rozmnozovani
  if (age >= min-age and random-float 100.0 < 2 * mira-rozrustani and gender = "female") [
    hatch 1 [
      set age 0
      set-gender
        if lutheran? [ set-lutheranism  set converted? false set born-lutheran born-lutheran + 1]
        if catholic? [ set-catholicism  set converted? false set born-catholic born-catholic + 1 ]
        if atheist? [ set-atheist set converted? false set born-atheist born-atheist + 1]
    ]
  ]
end

to week-counter ; pocitadlo tydnu
  set tydny tydny + 1
  if tydny = 53 [
    set tydny 1
  ]
end


to set-age ; nastaveni veku
  set age random 36 * 52
end

to set-gender ; nastaveni pohlavi
  ifelse random 2 = 0
  [ set gender "male" ]
  [ set gender "female" ]
end

to die-for-reasons ; usmrcovani lidi a zvysovani pocitadla
  if age > 35 * 12 and random-float 100 < 1 [ set i-see-dead-people i-see-dead-people + 1 die ] ; pokud prekroci life expectancy, maji sanci na umreni 1%
  if random-float 100 < 0.0001 [ set i-see-dead-people i-see-dead-people + 1 die ] ; muzou umrit kdykoli a z ruznych pricin
end


to reevaluate-religion ; reevaluace nabozenstvi
  if ticks mod reeval-freq = 0 [
    if (lutheran? and ticks - datum-konverze > 52) [ ; reevaluje az po roce od konverze
      if random 100 < reeval-chance-lutheran [
       convert-to-atheism
       set self-converted-lutherans-to-atheism self-converted-lutherans-to-atheism + 1
      ]
    ]
  if (catholic? and ticks - datum-konverze > 52) [
     if random 100 < reeval-chance-catholic [
       convert-to-atheism
       set self-converted-catholics-to-atheism self-converted-catholics-to-atheism + 1
      ]
    ]
  ]
 end

to persuade-catholics ; konvertovani katolika
  let chyceny one-of turtles-here with [ catholic? and not converted?]
  if (chyceny != nobody ) ; tady mela jit podminka
      [ ask chyceny [
       set converted? true
       set-lutheranism
       set datum-konverze ticks
       set persuaded-catholics persuaded-catholics + 1 ]
  ]
end

to persuade-lutherans ; konvertovani luterana
  let chyceny one-of turtles-here with [ lutheran? and not converted? ]
  if (chyceny != nobody ) [
    ask chyceny [
      set-catholicism
      set converted? true
      set datum-konverze ticks
      set persuaded-lutherans persuaded-lutherans + 1 ]
  ]
end

to set-lutheranism ;nastaveni luteranstvi
  set lutheran? true
  set atheist? false
  set catholic? false
  set size 2
  set color black
end

to set-catholicism ;nastaveni katolicismu
  set catholic? true
  set atheist? false
  set lutheran? false
  set size 1
  set color yellow
end

to set-atheist ;nastaveni ateismu
  set catholic? false
  set atheist? true
  set lutheran? false
  set size 1
  set color green
end

to convert-to-atheism ; konvertovani k ateismu
  set catholic? false
  set lutheran? false
  set atheist? true
  set color green
  set size 1
end
@#$#@#$#@
GRAPHICS-WINDOW
322
10
1131
820
-1
-1
1.0
1
10
1
1
1
0
1
1
1
-400
400
-400
400
0
0
1
ticks
30.0

BUTTON
5
91
175
140
Nastavit
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
10
552
315
585
reeval-freq
reeval-freq
4
520
52.0
1
1
weeks
HORIZONTAL

SLIDER
4
223
318
256
pocet-luteranu
pocet-luteranu
1
20
20.0
1
1
NIL
HORIZONTAL

SLIDER
10
590
316
623
reeval-chance-lutheran
reeval-chance-lutheran
0
100
3.0
1
1
%
HORIZONTAL

SLIDER
11
628
317
661
reeval-chance-catholic
reeval-chance-catholic
0
100
6.0
1
1
%
HORIZONTAL

TEXTBOX
11
10
306
86
Všechny počty lidí jsou ve stovkách pro zlepšení výkonu simulace.\n
15
0.0
1

BUTTON
175
91
316
140
Spustit
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
8
718
317
767
Luteráni, kteří samovolně zanechali náboženství
z-lutheranu-atheisti
17
1
12

MONITOR
9
768
317
817
Katolíci, kteří samovolně zanechali náboženství
z-katoliku-atheisti
17
1
12

MONITOR
6
141
175
214
Píše se rok:
pocet-let
17
1
18

MONITOR
1133
68
1290
121
Celkový počet luteránů
pocet-aktivnich-luteranu
17
1
13

MONITOR
1133
122
1290
175
Celkový počet katolíků
pocet-aktivnich-katoliku
17
1
13

MONITOR
1134
176
1290
229
Celkový počet ateistů
pocet-aktivnich-ateistu
17
1
13

MONITOR
175
141
317
214
Týden číslo:
pocet-tydnu
17
1
18

MONITOR
1132
11
1290
68
Celková populace
celkova-populace
17
1
14

MONITOR
1133
282
1293
331
Narození luteráni
born-lutheran
17
1
12

MONITOR
1133
330
1293
379
Narození katolíci
born-atheist
17
1
12

SLIDER
11
425
313
458
cestovatelske-choutky
cestovatelske-choutky
0
100
56.0
1
1
%
HORIZONTAL

MONITOR
1134
600
1294
649
Katolíci -> luteráni
presvedceni-katolici
17
1
12

MONITOR
1134
549
1294
598
Luteráni -> katolíci
presvedceni-luterani
17
1
12

MONITOR
1133
378
1291
427
Narození ateisté
born-atheist
17
1
12

SLIDER
11
459
315
492
nadseni-pro-martina
nadseni-pro-martina
0
100
50.0
1
1
%
HORIZONTAL

SLIDER
10
493
314
526
rychlost-sireni
rychlost-sireni
0
2
2.0
0.1
1
NIL
HORIZONTAL

MONITOR
7
667
318
716
Počet úmrtí
umrlci
17
1
12

PLOT
1294
10
1759
280
Počet živých příslušníků náboženství
Čas
Počet
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Katolíci" 1.0 0 -4079321 true "" "plot count turtles with [catholic?]"
"Luterání" 1.0 0 -16777216 true "" "plot count turtles with [lutheran?]"
"Ateisté" 1.0 0 -14439633 true "" "plot count turtles with [atheist?]"

PLOT
1295
281
1759
548
Počet narozených příslušníků náboženství
Čas
Počet
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Katolíci" 1.0 0 -4079321 true "" "plot born-catholic"
"Luterání" 1.0 0 -16777216 true "" "plot born-lutheran"
"Ateisté" 1.0 0 -14439633 true "" "plot born-atheist"

PLOT
1296
549
1759
812
Počet kovertovaných katolíků a luteránů
Čas
Počet
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Konvertovaní katolíci" 1.0 0 -7171555 true "" "plot persuaded-catholics"
"Konvertovaní luteráni" 1.0 0 -16777216 true "" "plot persuaded-lutherans"

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
